/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.lifecycle.ClientWindowFactory;
import org.apache.myfaces.test.mock.MockClientWindow;

public class MockClientWindowFactory
extends ClientWindowFactory {
    private static final String WINDOW_MODE_NONE = "none";
    private static final String WINDOW_MODE_MOCK = "mock";
    private String windowMode;

    public ClientWindow getClientWindow(FacesContext facesContext) {
        if (WINDOW_MODE_NONE.equals(this.getWindowMode(facesContext))) {
            return null;
        }
        if (WINDOW_MODE_MOCK.equals(this.getWindowMode(facesContext))) {
            return new MockClientWindow();
        }
        return null;
    }

    private String getWindowMode(FacesContext context) {
        if (this.windowMode == null) {
            this.windowMode = MockClientWindowFactory.getStringInitParameter(context.getExternalContext(), "jakarta.faces.CLIENT_WINDOW_MODE", WINDOW_MODE_NONE);
        }
        return this.windowMode;
    }

    private static String getStringInitParameter(ExternalContext context, String name, String defaultValue) {
        if (name == null) {
            throw new NullPointerException();
        }
        String param = context.getInitParameter(name);
        if (param == null) {
            return defaultValue;
        }
        if ((param = param.trim()).length() == 0) {
            return defaultValue;
        }
        return param;
    }
}

