/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.context.Flash;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.test.mock.MockExternalContext12;
import org.apache.myfaces.test.mock.MockFlash;

public abstract class MockExternalContext20
extends MockExternalContext12 {
    private static final String URL_PARAM_SEPERATOR = "&";
    private static final String URL_QUERY_SEPERATOR = "?";
    private static final String URL_FRAGMENT_SEPERATOR = "#";
    private static final String URL_NAME_VALUE_PAIR_SEPERATOR = "=";

    public MockExternalContext20(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.response.encodeURL(this.encodeURL(baseUrl, parameters));
    }

    private String encodeURL(String baseUrl, Map<String, List<String>> parameters) {
        String fragment = null;
        String queryString = null;
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        int index = baseUrl.indexOf(URL_FRAGMENT_SEPERATOR);
        if (index != -1) {
            fragment = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
        }
        if ((index = baseUrl.indexOf(URL_QUERY_SEPERATOR)) != -1) {
            queryString = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
            String[] nameValuePairs = queryString.split(URL_PARAM_SEPERATOR);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                String[] currentPair = nameValuePairs[i].split(URL_NAME_VALUE_PAIR_SEPERATOR);
                if (currentPair[1] == null) continue;
                ArrayList<String> value = new ArrayList<String>(1);
                value.add(currentPair[1]);
                paramMap.put(currentPair[0], value);
            }
        }
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                if (pair.getKey() == null || pair.getKey().trim().length() == 0) continue;
                paramMap.put(pair.getKey(), pair.getValue());
            }
        }
        StringBuilder newUrl = new StringBuilder(baseUrl);
        if (paramMap.size() > 0) {
            boolean isFirstPair = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (String value : (List)pair.getValue()) {
                    if (!isFirstPair) {
                        newUrl.append(URL_PARAM_SEPERATOR);
                    } else {
                        newUrl.append(URL_QUERY_SEPERATOR);
                        isFirstPair = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append(URL_NAME_VALUE_PAIR_SEPERATOR);
                    try {
                        newUrl.append(URLEncoder.encode(value, this.getResponseCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append(URL_FRAGMENT_SEPERATOR + fragment);
        }
        return newUrl.toString();
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.response.encodeRedirectURL(this.encodeURL(baseUrl, parameters));
    }

    public String encodePartialActionURL(String url) {
        return this.response.encodeURL(url);
    }

    public String getContextName() {
        return this.context.getServletContextName();
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        if (message == null) {
            this.response.sendError(statusCode);
        } else {
            this.response.sendError(statusCode, message);
        }
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String getRequestScheme() {
        return this.request.getScheme();
    }

    public String getRequestServerName() {
        return this.request.getServerName();
    }

    public int getRequestServerPort() {
        return this.request.getServerPort();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setResponseContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public Flash getFlash() {
        return MockFlash.getCurrentInstance(this);
    }

    public void setResponseContentLength(int length) {
        this.response.setContentLength(length);
    }

    public int getRequestContentLength() {
        return this.request.getContentLength();
    }

    public int getResponseBufferSize() {
        return this.response.getBufferSize();
    }

    public void setResponseBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public void setResponseStatus(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void invalidateSession() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isResponseCommitted() {
        return this.response.isCommitted();
    }

    public void responseFlushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void responseReset() {
        this.response.reset();
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        Cookie cookie = new Cookie(name, value);
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String propertyKey = entry.getKey();
                Object propertyValue = entry.getValue();
                if ("comment".equals(propertyKey)) {
                    cookie.setComment((String)propertyValue);
                    continue;
                }
                if ("domain".equals(propertyKey)) {
                    cookie.setDomain((String)propertyValue);
                    continue;
                }
                if ("maxAge".equals(propertyKey)) {
                    cookie.setMaxAge(((Integer)propertyValue).intValue());
                    continue;
                }
                if ("secure".equals(propertyKey)) {
                    cookie.setSecure(((Boolean)propertyValue).booleanValue());
                    continue;
                }
                if ("path".equals(propertyKey)) {
                    cookie.setPath((String)propertyValue);
                    continue;
                }
                throw new IllegalArgumentException("Unused key when creating Cookie");
            }
        }
        this.response.addCookie(cookie);
    }

    public void addResponseHeader(String name, String value) {
        this.response.addHeader(name, value);
    }
}

