/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.PropertyNotFoundException;
import jakarta.faces.el.PropertyResolver;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

public class MockPropertyResolver
extends PropertyResolver {
    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            return ((Map)base).get(property);
        }
        String name = property.toString();
        PropertyDescriptor descriptor = this.descriptor(base.getClass(), name);
        try {
            return descriptor.getReadMethod().invoke(base, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
    }

    public Object getValue(Object base, int index) throws PropertyNotFoundException {
        if (base instanceof List) {
            List l = (List)base;
            return index < l.size() ? l.get(index) : null;
        }
        if (base != null && base.getClass().isArray()) {
            return index < Array.getLength(base) ? Array.get(base, index) : null;
        }
        return this.getValue(base, "" + index);
    }

    public void setValue(Object base, Object property, Object value) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            ((Map)base).put(property, value);
            return;
        }
        String name = property.toString();
        PropertyDescriptor descriptor = this.descriptor(base.getClass(), name);
        try {
            descriptor.getWriteMethod().invoke(base, value);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new EvaluationException(e.getTargetException());
        }
    }

    public void setValue(Object base, int index, Object value) throws PropertyNotFoundException {
        if (base instanceof List) {
            List l = (List)base;
            if (index > l.size()) {
                throw new PropertyNotFoundException();
            }
            l.set(index, value);
            return;
        }
        if (base != null && base.getClass().isArray()) {
            if (index < Array.getLength(base)) {
                Array.set(base, index, value);
                return;
            }
            throw new PropertyNotFoundException();
        }
        this.setValue(base, "" + index, value);
    }

    public boolean isReadOnly(Object base, Object property) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            return false;
        }
        String name = property.toString();
        PropertyDescriptor descriptor = this.descriptor(base.getClass(), name);
        return descriptor.getWriteMethod() == null;
    }

    public boolean isReadOnly(Object base, int index) throws PropertyNotFoundException {
        return this.isReadOnly(base, "" + index);
    }

    public Class getType(Object base, Object property) throws PropertyNotFoundException {
        if (base == null) {
            throw new NullPointerException();
        }
        if (base instanceof Map) {
            Object value = ((Map)base).get(property);
            if (value != null) {
                return value.getClass();
            }
            return Object.class;
        }
        String name = property.toString();
        PropertyDescriptor descriptor = this.descriptor(base.getClass(), name);
        return descriptor.getPropertyType();
    }

    public Class getType(Object base, int index) throws PropertyNotFoundException {
        if (base instanceof List) {
            if (index < ((List)base).size()) {
                Object element = this.getValue(base, index);
                return element == null ? null : element.getClass();
            }
            throw new PropertyNotFoundException();
        }
        if (base != null && base.getClass().isArray()) {
            if (index < Array.getLength(base)) {
                Object element = Array.get(base, index);
                return element != null ? element.getClass() : base.getClass().getComponentType();
            }
            throw new PropertyNotFoundException();
        }
        return this.getType(base, "" + index);
    }

    private PropertyDescriptor descriptor(Class clazz, String name) {
        System.err.println("descriptor(class=" + clazz.getName() + ", name=" + name);
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(clazz);
            System.err.println("  Found BeanInfo " + info);
        }
        catch (IntrospectionException e) {
            throw new EvaluationException((Throwable)e);
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!name.equals(descriptors[i].getName())) continue;
            System.err.print("  Found PropertyDescriptor " + descriptors[i]);
            return descriptors[i];
        }
        System.err.print("  No property descriptor for property " + name);
        throw new PropertyNotFoundException(name);
    }
}

