/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Locale;
import org.apache.myfaces.test.config.ResourceBundleVarNames;
import org.apache.myfaces.test.mock.MockApplication;
import org.apache.myfaces.test.mock.MockApplication10;
import org.apache.myfaces.test.mock.MockExternalContext;
import org.apache.myfaces.test.mock.MockFacesContext;
import org.apache.myfaces.test.mock.MockFacesContextFactory;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpServletResponse;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockRenderKit;
import org.apache.myfaces.test.mock.MockServletConfig;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockWebContainer;
import org.apache.myfaces.test.mock.lifecycle.MockLifecycle;
import org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory;

public class MockedJsfTestContainer
implements HttpSessionListener {
    protected MockApplication application = null;
    protected MockServletConfig config = null;
    protected MockExternalContext externalContext = null;
    protected MockFacesContext facesContext = null;
    protected MockFacesContextFactory facesContextFactory = null;
    protected MockLifecycle lifecycle = null;
    protected MockLifecycleFactory lifecycleFactory = null;
    protected MockRenderKit renderKit = null;
    protected MockHttpServletRequest request = null;
    protected boolean requestInitializedCalled = false;
    protected MockHttpServletResponse response = null;
    protected MockHttpSession lastSession = null;
    protected MockServletContext servletContext = null;
    private MockWebContainer webContainer = null;

    public void setUp() {
        this.setUpServletContext();
        FactoryFinder.releaseFactories();
        this.setFactories();
        this.setUpJSFObjects();
    }

    public void setUpAll() {
        this.setUp();
        this.startRequest();
    }

    public void tearDownAll() {
        this.endRequest();
        this.tearDownRequest();
    }

    protected void setUpJSFObjects() {
        this.setUpLifecycle();
        this.setUpApplication();
        this.setUpRenderKit();
    }

    protected void setUpServletContext() {
        this.servletContext = new MockServletContext();
        this.config = new MockServletConfig(this.servletContext);
        this.webContainer = new MockWebContainer();
        this.servletContext.setWebContainer(this.webContainer);
        this.webContainer.subscribeListener(this);
    }

    protected void setUpRequest() {
        this.request = this.lastSession == null ? new MockHttpServletRequest() : new MockHttpServletRequest(this.lastSession);
        this.requestInitializedCalled = false;
        this.request.setServletContext(this.servletContext);
        this.response = new MockHttpServletResponse();
    }

    protected void doRequestInitialized() {
        if (!this.requestInitializedCalled) {
            this.webContainer.requestInitialized(new ServletRequestEvent((ServletContext)this.servletContext, (ServletRequest)this.request));
            this.requestInitializedCalled = true;
        }
    }

    public void startRequest() {
        this.setUpRequest();
        this.doRequestInitialized();
        this.setUpFacesContext();
        this.setUpDefaultView();
    }

    public void startSession() {
        if (this.request != null) {
            this.request.getSession(true);
        }
    }

    public void endSession() {
        MockHttpSession session = (MockHttpSession)this.request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.lastSession = (MockHttpSession)se.getSession();
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.lastSession = null;
    }

    protected void setFactories() {
        FactoryFinder.setFactory((String)"jakarta.faces.application.ApplicationFactory", (String)"org.apache.myfaces.test.mock.MockApplicationFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.FacesContextFactory", (String)"org.apache.myfaces.test.mock.MockFacesContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.lifecycle.LifecycleFactory", (String)"org.apache.myfaces.test.mock.lifecycle.MockLifecycleFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.render.RenderKitFactory", (String)"org.apache.myfaces.test.mock.MockRenderKitFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.ExceptionHandlerFactory", (String)"org.apache.myfaces.test.mock.MockExceptionHandlerFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.context.PartialViewContextFactory", (String)"org.apache.myfaces.test.mock.MockPartialViewContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.component.visit.VisitContextFactory", (String)"org.apache.myfaces.test.mock.visit.MockVisitContextFactory");
        FactoryFinder.setFactory((String)"jakarta.faces.lifecycle.ClientWindowFactory", (String)"org.apache.myfaces.test.mock.MockClientWindowFactory");
    }

    protected void setUpLifecycle() {
        this.lifecycleFactory = (MockLifecycleFactory)((Object)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory"));
        this.lifecycle = (MockLifecycle)this.lifecycleFactory.getLifecycle("DEFAULT");
    }

    protected void setUpFacesContext() {
        this.facesContextFactory = (MockFacesContextFactory)((Object)FactoryFinder.getFactory((String)"jakarta.faces.context.FacesContextFactory"));
        this.facesContext = (MockFacesContext)this.facesContextFactory.getFacesContext(this.servletContext, this.request, this.response, this.lifecycle);
        if (this.facesContext.getExternalContext() != null) {
            this.externalContext = (MockExternalContext)this.facesContext.getExternalContext();
        } else {
            this.externalContext = new MockExternalContext(this.servletContext, this.request, this.response);
            this.facesContext.setExternalContext(this.externalContext);
        }
        this.facesContext.setApplication(this.application);
    }

    protected void setUpDefaultView() {
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/viewId");
        root.setLocale(this.getLocale());
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot(root);
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected void setUpApplication() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory");
        this.application = (MockApplication)applicationFactory.getApplication();
    }

    protected void setUpRenderKit() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        this.renderKit = new MockRenderKit();
        renderKitFactory.addRenderKit("HTML_BASIC", (RenderKit)this.renderKit);
    }

    public MockApplication10 getApplication() {
        return this.application;
    }

    public MockExternalContext getExternalContext() {
        return this.externalContext;
    }

    public MockFacesContext getFacesContext() {
        return this.facesContext;
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    public MockServletContext getServletContext() {
        return this.servletContext;
    }

    public MockWebContainer getWebContainer() {
        return this.webContainer;
    }

    public final void endRequest() {
        this.doRequestDestroyed();
        this.tearDownRequest();
    }

    protected void doRequestDestroyed() {
        if (this.request != null) {
            this.webContainer.requestDestroyed(new ServletRequestEvent((ServletContext)this.servletContext, (ServletRequest)this.request));
        }
    }

    protected void tearDownRequest() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        this.externalContext = null;
        this.facesContext = null;
        this.request = null;
        this.response = null;
    }

    public void tearDown() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        this.application = null;
        this.config = null;
        this.externalContext = null;
        this.facesContext = null;
        this.lifecycle = null;
        this.lifecycleFactory = null;
        this.renderKit = null;
        this.request = null;
        this.response = null;
        this.servletContext = null;
        this.lastSession = null;
        this.webContainer = null;
        FactoryFinder.releaseFactories();
        ResourceBundleVarNames.resetNames();
    }
}

