/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.test.el.MockValueExpression;

public class MockCompositeValueExpression
extends MockValueExpression {
    private static final long serialVersionUID = 2645070462654392076L;
    private List<ValueExpression> valueExpressionChain;

    public MockCompositeValueExpression(String expression, Class expectedType) {
        super("#{}", expectedType);
        this.buildExpressionChain(expression, expectedType);
    }

    private void buildExpressionChain(String expression, Class expectedType) {
        this.valueExpressionChain = new ArrayList<ValueExpression>();
        StringBuilder parser = new StringBuilder(expression);
        int pos = MockCompositeValueExpression.getStartPositionOfReference(parser);
        while (pos > -1 || parser.length() > 0) {
            if (pos > 0) {
                this.valueExpressionChain.add(new MockValueExpression(parser.substring(0, pos), expectedType));
                parser.delete(0, pos);
            }
            if (pos == 0) {
                int posBracket = parser.indexOf("}");
                this.valueExpressionChain.add(new MockValueExpression(parser.substring(0, posBracket + 1), expectedType));
                parser.delete(0, posBracket + 1);
            }
            if (pos == -1) {
                this.valueExpressionChain.add(new MockValueExpression(parser.toString(), expectedType));
                parser.setLength(0);
            }
            pos = MockCompositeValueExpression.getStartPositionOfReference(parser);
        }
    }

    @Override
    public Class getType(ELContext context) {
        switch (this.valueExpressionChain.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.valueExpressionChain.get(0).getType(context);
            }
        }
        return String.class;
    }

    @Override
    public Object getValue(ELContext context) {
        if (this.valueExpressionChain.size() > 1) {
            Object result = "";
            for (ValueExpression valueExpression : this.valueExpressionChain) {
                result = (String)result + valueExpression.getValue(context);
            }
            return result;
        }
        if (this.valueExpressionChain.size() == 1) {
            return this.valueExpressionChain.get(0).getValue(context);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object value) {
        if (this.isReadOnly(context)) {
            throw new IllegalArgumentException("We can only set value on NON composite expressions like #{foo}");
        }
        this.valueExpressionChain.get(0).setValue(context, value);
    }

    @Override
    public String getExpressionString() {
        StringBuilder result = new StringBuilder();
        for (ValueExpression valueExpression : this.valueExpressionChain) {
            result.append(valueExpression.getExpressionString());
        }
        return result.toString();
    }

    @Override
    public boolean isReadOnly(ELContext context) {
        return this.valueExpressionChain.size() > 1;
    }

    public static int getStartPositionOfReference(StringBuilder expressionPart) {
        int pos1 = expressionPart.indexOf("#{");
        int pos2 = expressionPart.indexOf("${");
        int result = pos1 == -1 ? pos1 : (pos2 == -1 ? pos1 : Math.min(pos1, pos2));
        return result;
    }
}

