/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import jakarta.el.ELContext;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.test.el.AbstractELResolver;

public class ReservedWordsELResolver
extends AbstractELResolver {
    private static final Map<String, Object> VALUES;
    private List<FeatureDescriptor> featureDescriptors;

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && VALUES.containsKey(property)) {
            context.setPropertyResolved(true);
            return VALUES.get(property);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null && VALUES.containsKey(property)) {
            context.setPropertyResolved(true);
            Object value = VALUES.get(property);
            return value == null ? null : value.getClass();
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && VALUES.containsKey(property)) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException(property.toString());
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && VALUES.containsKey(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public synchronized Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.featureDescriptors == null) {
            this.featureDescriptors = new ArrayList<FeatureDescriptor>();
            for (Map.Entry<String, Object> e : VALUES.entrySet()) {
                Class<?> type = e.getValue() == null ? null : e.getValue().getClass();
                this.featureDescriptors.add(this.descriptor(e.getKey(), e.getKey(), e.getKey(), false, false, true, type, true));
            }
            this.featureDescriptors = Collections.unmodifiableList(this.featureDescriptors);
        }
        return this.featureDescriptors.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return base == null ? String.class : null;
    }

    static {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("true", Boolean.TRUE);
        values.put("false", Boolean.FALSE);
        values.put("null", null);
        VALUES = Collections.unmodifiableMap(values);
    }
}

