/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.myfaces.test.mock.MockEnumeration;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockServletInputStream;
import org.apache.myfaces.test.mock.MockWebContainer;

public class MockHttpServletRequest
implements HttpServletRequest {
    private List attributeListeners = new ArrayList();
    private HashMap attributes = new HashMap();
    private String contextPath = null;
    private List headers = new ArrayList();
    private Locale locale = null;
    private HashMap parameters = new HashMap();
    private String pathInfo = null;
    private Principal principal = null;
    private String queryString = null;
    private ServletContext servletContext = null;
    private String servletPath = null;
    private HttpSession session = null;
    private String characterEncoding = null;
    private ServletInputStream inputStream = null;
    private List cookies = new ArrayList();
    private Vector locales = null;
    private String method = null;
    private List<String> roles = null;
    private static SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    public MockHttpServletRequest() {
    }

    public MockHttpServletRequest(HttpSession session) {
        this.setHttpSession(session);
    }

    public MockHttpServletRequest(String contextPath, String servletPath, String pathInfo, String queryString) {
        this.setPathElements(contextPath, servletPath, pathInfo, queryString);
    }

    public MockHttpServletRequest(String contextPath, String servletPath, String pathInfo, String queryString, HttpSession session) {
        this.setPathElements(contextPath, servletPath, pathInfo, queryString);
        this.setHttpSession(session);
    }

    public void addAttributeListener(ServletRequestAttributeListener listener) {
        this.attributeListeners.add(listener);
    }

    public void addDateHeader(String name, long value) {
        this.headers.add(name + ": " + this.formatDate(value));
    }

    public void addHeader(String name, String value) {
        this.headers.add(name + ": " + value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.add(name + ": " + value);
    }

    public void addParameter(String name, String value) {
        String[] values = (String[])this.parameters.get(name);
        if (values == null) {
            String[] results = new String[]{value};
            this.parameters.put(name, results);
            return;
        }
        String[] results = new String[values.length + 1];
        System.arraycopy(values, 0, results, 0, values.length);
        results[values.length] = value;
        this.parameters.put(name, results);
    }

    public void addCookie(Cookie c) {
        for (int i = 0; i < this.cookies.size(); ++i) {
            if (!((Cookie)this.cookies.get(i)).getName().equals(c.getName())) continue;
            this.cookies.set(i, c);
            return;
        }
        this.cookies.add(c);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setHttpSession(HttpSession session) {
        this.session = session;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setPathElements(String contextPath, String servletPath, String pathInfo, String queryString) {
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setUserPrincipal(Principal principal) {
        this.principal = principal;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected MockWebContainer getWebContainer() {
        if (this.servletContext instanceof MockServletContext) {
            return ((MockServletContext)this.servletContext).getWebContainer();
        }
        return null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void addUserRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public void clearUserRoles() {
        if (this.roles == null) {
            return;
        }
        this.roles.clear();
    }

    public String getAuthType() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        Cookie[] array = new Cookie[this.cookies.size()];
        for (int i = 0; i < this.cookies.size(); ++i) {
            array[i] = (Cookie)this.cookies.get(i);
        }
        return array;
    }

    public long getDateHeader(String name) {
        String match = name + ":";
        for (String header : this.headers) {
            if (!header.startsWith(match)) continue;
            return this.parseDate(header.substring(match.length() + 1).trim());
        }
        return -1L;
    }

    public String getHeader(String name) {
        String match = name + ":";
        for (String header : this.headers) {
            if (!header.startsWith(match)) continue;
            return header.substring(match.length() + 1).trim();
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        Vector<String> values = new Vector<String>();
        for (String header : this.headers) {
            String name;
            int colon = header.indexOf(58);
            if (colon < 0 || values.contains(name = header.substring(0, colon).trim())) continue;
            values.add(name);
        }
        return values.elements();
    }

    public Enumeration getHeaders(String name) {
        String match = name + ":";
        Vector<String> values = new Vector<String>();
        for (String header : this.headers) {
            if (!header.startsWith(match)) continue;
            values.add(header.substring(match.length() + 1).trim());
        }
        return values.elements();
    }

    public int getIntHeader(String name) {
        String match = name + ":";
        for (String header : this.headers) {
            if (!header.startsWith(match)) continue;
            return Integer.parseInt(header.substring(match.length() + 1).trim());
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        StringBuffer sb = new StringBuffer();
        if (this.contextPath != null) {
            sb.append(this.contextPath);
        }
        if (this.servletPath != null) {
            sb.append(this.servletPath);
        }
        if (this.pathInfo != null) {
            sb.append(this.pathInfo);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        throw new UnsupportedOperationException();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            this.session = new MockHttpSession(this.servletContext);
            MockWebContainer container = this.getWebContainer();
            if (container != null) {
                HttpSessionEvent se = new HttpSessionEvent(this.session);
                container.sessionCreated(se);
            }
        }
        return this.session;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        return this.roles != null ? this.roles.contains(role) : false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public ServletInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(MockServletInputStream stream) {
        this.inputStream = stream;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        if (this.locales == null) {
            this.locales = new Vector<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        }
        return this.locales.elements();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return new MockEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() {
        if (this.inputStream != null) {
            try {
                InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)this.inputStream, this.characterEncoding) : new InputStreamReader((InputStream)this.inputStream);
                return new BufferedReader(sourceReader);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return "1.2.3.4";
    }

    public String getRemoteHost() {
        return "MyfacesServer";
    }

    public int getRemotePort() {
        return 46123;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 8080;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    private void fireAttributeAdded(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
        for (ServletRequestAttributeListener listener : this.attributeListeners) {
            listener.attributeAdded(event);
        }
    }

    private void fireAttributeRemoved(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
        for (ServletRequestAttributeListener listener : this.attributeListeners) {
            listener.attributeRemoved(event);
        }
    }

    private void fireAttributeReplaced(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.getServletContext(), (ServletRequest)this, key, value);
        for (ServletRequestAttributeListener listener : this.attributeListeners) {
            listener.attributeReplaced(event);
        }
    }

    private String formatDate(long date) {
        return format.format(new Date(date));
    }

    private long parseDate(String date) {
        try {
            return format.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(date);
        }
    }

    public boolean authenticate(HttpServletResponse hsr) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Part getPart(String string) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void login(String string, String string1) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncContext startAsync(ServletRequest sr, ServletResponse sr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> type) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HttpServletMapping getHttpServletMapping() {
        return super.getHttpServletMapping();
    }

    public PushBuilder newPushBuilder() {
        return super.newPushBuilder();
    }

    public Map<String, String> getTrailerFields() {
        return super.getTrailerFields();
    }

    public boolean isTrailerFieldsReady() {
        return super.isTrailerFieldsReady();
    }

    public String getRequestId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getProtocolRequestId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

