/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.apache.myfaces.test.mock.MockEnumeration;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockWebContainer;

public class MockHttpSession
implements HttpSession {
    private List attributeListeners = new ArrayList();
    private HashMap attributes = new HashMap();
    private String id = "123";
    private ServletContext servletContext = null;
    private boolean invalid = false;
    private MockWebContainer webContainer;

    public MockHttpSession() {
    }

    public MockHttpSession(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            this.attributeListeners.add(listener);
        } else {
            container.subscribeListener(listener);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected MockWebContainer getWebContainer() {
        if (this.servletContext instanceof MockServletContext) {
            return ((MockServletContext)this.servletContext).getWebContainer();
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getAttribute(String name) {
        this.assertValidity();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.assertValidity();
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getValue(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getValueNames() {
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        this.assertValidity();
        this.attributes.clear();
        this.invalid = true;
        MockWebContainer container = this.getWebContainer();
        if (container != null) {
            HttpSessionEvent se = new HttpSessionEvent((HttpSession)this);
            container.sessionDestroyed(se);
        }
    }

    public boolean isNew() {
        throw new UnsupportedOperationException();
    }

    public void putValue(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        this.assertValidity();
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void removeValue(String name) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        this.assertValidity();
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue, value);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }

    private void fireAttributeAdded(String key, Object value) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            for (HttpSessionAttributeListener listener : this.attributeListeners) {
                listener.attributeAdded(event);
            }
        } else {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            container.attributeAdded(event);
        }
    }

    private void fireAttributeRemoved(String key, Object value) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(event);
            }
            for (HttpSessionAttributeListener listener : this.attributeListeners) {
                listener.attributeRemoved(event);
            }
        } else {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(event);
            }
            container.attributeRemoved(event);
        }
    }

    private void fireAttributeReplaced(String key, Object oldValue, Object value) {
        MockWebContainer container;
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, oldValue);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((container = this.getWebContainer()) == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            for (HttpSessionAttributeListener listener : this.attributeListeners) {
                listener.attributeReplaced(event);
            }
        } else {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
            if (value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            container.attributeReplaced(event);
        }
    }

    private void assertValidity() {
        if (this.invalid) {
            throw new IllegalStateException("Session is invalid.");
        }
    }
}

