/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.ResponseStateManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.myfaces.test.mock._Hex;

public class MockResponseStateManager
extends ResponseStateManager {
    private static final int TREE_PARAM = 0;
    private static final int STATE_PARAM = 1;
    private static final int VIEWID_PARAM = 2;
    private static final String ZIP_CHARSET = "ISO-8859-1";

    public Object getState(FacesContext facesContext, String viewId) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return new Object[]{savedState[0], savedState[1]};
    }

    public Object getTreeStructureToRestore(FacesContext facesContext, String viewId) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return savedState[0];
    }

    public Object getComponentStateToRestore(FacesContext facesContext) {
        Object[] savedState = this.getSavedState(facesContext);
        if (savedState == null) {
            return null;
        }
        return savedState[1];
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("jakarta.faces.ViewState");
    }

    private void writeViewStateField(FacesContext facesContext, ResponseWriter responseWriter, Object savedState) throws IOException {
        String serializedState = this.construct(facesContext, savedState);
        responseWriter.startElement("input", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("name", (Object)"jakarta.faces.ViewState", null);
        responseWriter.writeAttribute("value", (Object)serializedState, null);
        responseWriter.endElement("input");
    }

    private void writeRenderKitIdField(FacesContext facesContext, ResponseWriter responseWriter) throws IOException {
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (defaultRenderKitId != null && !"HTML_BASIC".equals(defaultRenderKitId)) {
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            responseWriter.writeAttribute("name", (Object)"jakarta.faces.RenderKitId", null);
            responseWriter.writeAttribute("value", (Object)defaultRenderKitId, null);
            responseWriter.endElement("input");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String construct(FacesContext facesContext, Object savedState) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(savedState);
            bytes = baos.toByteArray();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    oos = null;
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    baos = null;
                }
            }
        }
        return new String(new _Hex().encode(bytes), ZIP_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object reconstruct(FacesContext facesContext, String encodedState) throws IOException {
        byte[] bytes = encodedState.getBytes(ZIP_CHARSET);
        try {
            bytes = new _Hex().decode(bytes);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        ByteArrayInputStream input = null;
        ObjectInputStream s = null;
        Object object = null;
        try {
            input = new ByteArrayInputStream(bytes);
            s = new ObjectInputStream(input);
            object = s.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    s = null;
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    input = null;
                }
            }
        }
        return object;
    }

    private Object[] getSavedState(FacesContext facesContext) {
        Object encodedState = facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.ViewState");
        if (encodedState == null || ((String)encodedState).length() == 0) {
            return null;
        }
        Object[] savedState = null;
        try {
            savedState = (Object[])this.reconstruct(facesContext, (String)encodedState);
        }
        catch (IOException e) {
            facesContext.getExternalContext().log("Cannot reconstruct view state", (Throwable)e);
        }
        if (savedState == null) {
            return null;
        }
        String restoredViewId = (String)savedState[2];
        if (restoredViewId == null) {
            return null;
        }
        return savedState;
    }

    public String getViewState(FacesContext facesContext, Object state) {
        Object[] structureAndState;
        if (state == null) {
            return null;
        }
        Object treeStruct = null;
        Object compStates = null;
        if (state instanceof Object[]) {
            structureAndState = (Object[])state;
            if (structureAndState.length != 2) {
                throw new FacesException("The state should be an array of Object[] of lenght 2");
            }
        } else {
            throw new FacesException("The state should be an array of Object[] of lenght 2, or a SerializedView instance");
        }
        treeStruct = structureAndState[0];
        compStates = structureAndState[1];
        Object[] savedState = new Object[3];
        if (facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext)) {
            if (treeStruct != null) {
                savedState[0] = treeStruct;
            }
            if (compStates != null) {
                savedState[1] = compStates;
            }
        } else if (treeStruct != null && treeStruct instanceof String) {
            savedState[0] = treeStruct;
        }
        savedState[2] = facesContext.getViewRoot().getViewId();
        try {
            return this.construct(facesContext, savedState);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

