/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.test.mock.MockRequestDispatcher;
import org.apache.myfaces.test.mock.MockServletRegistration;
import org.apache.myfaces.test.mock.MockWebContainer;

public class MockServletContext
implements ServletContext {
    private Hashtable attributes = new Hashtable();
    private File documentRoot = null;
    private Hashtable mimeTypes = new Hashtable();
    private Hashtable parameters = new Hashtable();
    private List attributeListeners = new ArrayList();
    private MockWebContainer webContainer;
    private Map<String, ServletRegistration> servletRegistrations = new HashMap<String, ServletRegistration>();
    private ClassLoader classLoader;

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addMimeType(String extension, String contentType) {
        this.mimeTypes.put(extension, contentType);
    }

    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public void setDocumentRoot(URI base) {
        File f = new File(base);
        if (!f.exists()) {
            throw new IllegalArgumentException("File: " + base.getPath() + " doesn't exist");
        }
        this.documentRoot = f;
    }

    public void addAttributeListener(ServletContextAttributeListener listener) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            this.attributeListeners.add(listener);
        } else {
            container.subscribeListener(listener);
        }
    }

    public MockWebContainer getWebContainer() {
        return this.webContainer;
    }

    public void setWebContainer(MockWebContainer container) {
        this.webContainer = container;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.parameters.keys();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String path) {
        int period = path.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = path.substring(period + 1);
        return (String)this.mimeTypes.get(extension);
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getRealPath(String path) {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            try {
                return resolved.getCanonicalPath();
            }
            catch (IOException e) {
                return resolved.getAbsolutePath();
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new MalformedURLException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            if (resolved.exists()) {
                return resolved.toURL();
            }
            return null;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.getResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        if (this.documentRoot == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
        }
        File node = new File(this.documentRoot, path.substring(1));
        if (!node.exists()) {
            return null;
        }
        if (!node.isDirectory()) {
            return null;
        }
        HashSet<CallSite> set = new HashSet<CallSite>();
        String[] files = node.list();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            String subfile = path + files[i];
            File subnode = new File(node, files[i]);
            if (subnode.isDirectory()) {
                subfile = subfile + "/";
            }
            set.add((CallSite)((Object)subfile));
        }
        return set;
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception exception, String message) {
        System.out.println(message);
        exception.printStackTrace();
    }

    public void log(String message, Throwable exception) {
        System.out.println(message);
        exception.printStackTrace();
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    public ServletContext getContext(String uripath) {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public String getServletContextName() {
        return "MockServletContext";
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        File f;
        URI uri = this.resolve(path);
        if (uri != null && (f = new File(uri)).exists()) {
            try {
                return new MockRequestDispatcher(uri.toURL());
            }
            catch (MalformedURLException e) {
                this.log(e.getMessage());
                return null;
            }
        }
        return null;
    }

    private final URI resolve(String path) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null");
        }
        if (path.charAt(0) == '/') {
            if (path.length() > 1) {
                return this.documentRoot.toURI().resolve(path.substring(1));
            }
            return this.documentRoot.toURI();
        }
        return null;
    }

    void fireAttributeAdded(String key, Object value) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            for (ServletContextAttributeListener listener : this.attributeListeners) {
                listener.attributeAdded(event);
            }
        } else {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            container.attributeAdded(event);
        }
    }

    void fireAttributeRemoved(String key, Object value) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            for (ServletContextAttributeListener listener : this.attributeListeners) {
                listener.attributeRemoved(event);
            }
        } else {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            container.attributeRemoved(event);
        }
    }

    void fireAttributeReplaced(String key, Object value) {
        MockWebContainer container = this.getWebContainer();
        if (container == null) {
            if (this.attributeListeners.size() < 1) {
                return;
            }
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            for (ServletContextAttributeListener listener : this.attributeListeners) {
                listener.attributeReplaced(event);
            }
        } else {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
            container.attributeReplaced(event);
        }
    }

    public boolean setInitParameter(String name, String value) {
        this.addInitParameter(name, value);
        return true;
    }

    public ServletRegistration.Dynamic addServlet(String name, String string1) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addServlet(String name, Servlet srvlt) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addServlet(String name, Class<? extends Servlet> type) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends Servlet> T createServlet(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration getServletRegistration(String name) {
        return this.servletRegistrations.get(name);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servletRegistrations;
    }

    public void addServletRegistration(String name, String servletClassName, String ... mappings) {
        MockServletRegistration sr = new MockServletRegistration(name, servletClassName, mappings);
        this.servletRegistrations.put(name, sr);
    }

    public FilterRegistration.Dynamic addFilter(String string, String string1) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration.Dynamic addFilter(String string, Filter filter) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> type) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends Filter> T createFilter(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration getFilterRegistration(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addListener(Class<? extends EventListener> type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addListener(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends EventListener> T createListener(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void declareRoles(String ... strings) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return new SessionCookieConfig(){

            public void setName(String s) {
            }

            public String getName() {
                return null;
            }

            public void setDomain(String s) {
            }

            public String getDomain() {
                return null;
            }

            public void setPath(String s) {
            }

            public String getPath() {
                return null;
            }

            public void setComment(String s) {
            }

            public String getComment() {
                return null;
            }

            public void setHttpOnly(boolean b) {
            }

            public boolean isHttpOnly() {
                return false;
            }

            public void setSecure(boolean b) {
            }

            public boolean isSecure() {
                return false;
            }

            public void setMaxAge(int i) {
            }

            public int getMaxAge() {
                return 0;
            }

            public void setAttribute(String s, String s1) {
            }

            public String getAttribute(String s) {
                return null;
            }

            public Map<String, String> getAttributes() {
                return new HashMap<String, String>();
            }
        };
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getEffectiveMajorVersion() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getEffectiveMinorVersion() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addJspFile(String string, String string1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getSessionTimeout() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSessionTimeout(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRequestCharacterEncoding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRequestCharacterEncoding(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getResponseCharacterEncoding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setResponseCharacterEncoding(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

