/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.myfaces.test.mock.MockDefaultViewDeclarationLanguage;

public class MockViewHandler
extends ViewHandler {
    public Locale calculateLocale(FacesContext context) {
        Locale locale = context.getApplication().getDefaultLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public String calculateRenderKitId(FacesContext context) {
        String renderKitId = context.getApplication().getDefaultRenderKitId();
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot view = new UIViewRoot();
        view.setViewId(viewId);
        if (locale != null) {
            view.setLocale(locale);
        } else {
            view.setLocale(context.getApplication().getViewHandler().calculateLocale(context));
        }
        if (renderKitId != null) {
            view.setRenderKitId(renderKitId);
        } else {
            view.setRenderKitId(context.getApplication().getViewHandler().calculateRenderKitId(context));
        }
        return view;
    }

    public String getActionURL(FacesContext context, String viewId) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + path;
    }

    public void renderView(FacesContext context, UIViewRoot view) {
        throw new UnsupportedOperationException();
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        throw new UnsupportedOperationException();
    }

    public void writeState(FacesContext context) {
    }

    public String getWebsocketURL(FacesContext context, String channelAndToken) {
        String url = context.getExternalContext().getRequestContextPath() + "/jakarta.faces.push/" + channelAndToken;
        return url;
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        String actionEncodedViewId = this.getActionURL(context, viewId);
        ExternalContext externalContext = context.getExternalContext();
        String bookmarkEncodedURL = externalContext.encodeBookmarkableURL(actionEncodedViewId, parameters);
        return externalContext.encodeActionURL(bookmarkEncodedURL);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return new MockDefaultViewDeclarationLanguage();
    }
}

