/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.lifecycle;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.test.mock.lifecycle.RestoreViewSupport;

public class DefaultRestoreViewSupport
implements RestoreViewSupport {
    private static final String JAKARTA_SERVLET_INCLUDE_SERVLET_PATH = "jakarta.servlet.include.servlet_path";
    private static final String JAKARTA_SERVLET_INCLUDE_PATH_INFO = "jakarta.servlet.include.path_info";
    private static final Logger log = Logger.getLogger(DefaultRestoreViewSupport.class.getName());

    @Override
    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        ValueExpression binding = component.getValueExpression("binding");
        if (binding != null) {
            binding.setValue(facesContext.getELContext(), (Object)component);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            this.processComponentBinding(facesContext, (UIComponent)iter.next());
        }
    }

    @Override
    public String calculateViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = (String)requestMap.get(JAKARTA_SERVLET_INCLUDE_PATH_INFO);
        if (viewId != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Calculated viewId '" + viewId + "' from request param 'jakarta.servlet.include.path_info'");
            }
        } else {
            viewId = externalContext.getRequestPathInfo();
            if (viewId != null && log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Calculated viewId '" + viewId + "' from request path info");
            }
        }
        if (viewId == null && (viewId = (String)requestMap.get(JAKARTA_SERVLET_INCLUDE_SERVLET_PATH)) != null && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Calculated viewId '" + viewId + "' from request param 'jakarta.servlet.include.servlet_path'");
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Calculated viewId '" + viewId + "' from request servlet path");
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    @Override
    public boolean isPostback(FacesContext facesContext) {
        return true;
    }
}

