/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.lifecycle;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.test.mock.lifecycle.ApplyRequestValuesExecutor;
import org.apache.myfaces.test.mock.lifecycle.InvokeApplicationExecutor;
import org.apache.myfaces.test.mock.lifecycle.PhaseExecutor;
import org.apache.myfaces.test.mock.lifecycle.PhaseListenerManager;
import org.apache.myfaces.test.mock.lifecycle.ProcessValidationsExecutor;
import org.apache.myfaces.test.mock.lifecycle.RenderResponseExecutor;
import org.apache.myfaces.test.mock.lifecycle.RestoreViewExecutor;
import org.apache.myfaces.test.mock.lifecycle.UpdateModelValuesExecutor;

public class MockLifecycle
extends Lifecycle {
    private List phaseListenerList = new ArrayList();
    private PhaseExecutor[] lifecycleExecutors = new PhaseExecutor[]{new RestoreViewExecutor(), new ApplyRequestValuesExecutor(), new ProcessValidationsExecutor(), new UpdateModelValuesExecutor(), new InvokeApplicationExecutor()};
    private PhaseExecutor renderExecutor = new RenderResponseExecutor();

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListenerList.add(listener);
    }

    public void execute(FacesContext context) throws FacesException {
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, context, this.getPhaseListeners());
        for (int executorIndex = 0; executorIndex < this.lifecycleExecutors.length; ++executorIndex) {
            if (!this.executePhase(context, this.lifecycleExecutors[executorIndex], phaseListenerMgr)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePhase(FacesContext facesContext, PhaseExecutor executor, PhaseListenerManager phaseListenerMgr) throws FacesException {
        boolean skipFurtherProcessing = false;
        try {
            phaseListenerMgr.informPhaseListenersBefore(executor.getPhase());
            if (this.isResponseComplete(facesContext, executor.getPhase(), true)) {
                boolean bl = true;
                return bl;
            }
            if (this.shouldRenderResponse(facesContext, executor.getPhase(), true)) {
                skipFurtherProcessing = true;
            }
            if (executor.execute(facesContext)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(executor.getPhase());
        }
        if (this.isResponseComplete(facesContext, executor.getPhase(), false) || this.shouldRenderResponse(facesContext, executor.getPhase(), false)) {
            skipFurtherProcessing = true;
        }
        return skipFurtherProcessing;
    }

    public PhaseListener[] getPhaseListeners() {
        return this.phaseListenerList.toArray(new PhaseListener[this.phaseListenerList.size()]);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListenerList.remove(listener);
    }

    public void render(FacesContext context) throws FacesException {
        if (this.isResponseComplete(context, this.renderExecutor.getPhase(), true)) {
            return;
        }
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, context, this.getPhaseListeners());
        try {
            phaseListenerMgr.informPhaseListenersBefore(this.renderExecutor.getPhase());
            if (this.isResponseComplete(context, this.renderExecutor.getPhase(), true)) {
                return;
            }
            this.renderExecutor.execute(context);
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(this.renderExecutor.getPhase());
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            flag = true;
        }
        return flag;
    }
}

