/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import java.io.InputStream;
import java.net.URL;
import org.apache.myfaces.test.mock.resource.MockResourceLoader;
import org.apache.myfaces.test.mock.resource.MockResourceMeta;

public class MockClassLoaderResourceLoader
extends MockResourceLoader {
    private ClassLoader _classLoader;

    public MockClassLoaderResourceLoader(ClassLoader loader, String prefix) {
        super(prefix);
        this._classLoader = loader;
    }

    @Override
    public String getLibraryVersion(String path) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(MockResourceMeta resourceMeta) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            return this.getClassLoader().getResourceAsStream(this.getPrefix() + "/" + resourceMeta.getResourceIdentifier());
        }
        return this.getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
    }

    @Override
    public URL getResourceURL(MockResourceMeta resourceMeta) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            return this.getClassLoader().getResource(this.getPrefix() + "/" + resourceMeta.getResourceIdentifier());
        }
        return this.getClassLoader().getResource(resourceMeta.getResourceIdentifier());
    }

    @Override
    public String getResourceVersion(String path) {
        return null;
    }

    @Override
    public MockResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new MockResourceMeta(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    public boolean libraryExists(String libraryName) {
        URL url;
        return this.getPrefix() != null && !"".equals(this.getPrefix()) ? (url = this.getClassLoader().getResource(this.getPrefix() + "/" + libraryName)) != null : (url = this.getClassLoader().getResource(libraryName)) != null;
    }
}

