/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.myfaces.test.mock.resource.MockResourceLoader;
import org.apache.myfaces.test.mock.resource.MockResourceMeta;

public class MockExternalContextResourceLoader
extends MockResourceLoader {
    protected static final Pattern VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*/");
    protected static final Pattern RESOURCE_VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*\\..*");

    public MockExternalContextResourceLoader(String prefix) {
        super(prefix);
    }

    protected Set<String> getResourcePaths(String path) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourcePaths(this.getPrefix() + "/" + path);
    }

    @Override
    public String getResourceVersion(String path) {
        String resourceVersion = null;
        Set<String> resourcePaths = this.getResourcePaths((String)path);
        if (this.getPrefix() != null) {
            path = this.getPrefix() + "/" + (String)path;
        }
        if (null != resourcePaths && !resourcePaths.isEmpty()) {
            for (String resourcePath : resourcePaths) {
                String version = resourcePath.substring(((String)path).length());
                if (!RESOURCE_VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.lastIndexOf(46));
                if (resourceVersion == null) {
                    resourceVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(resourceVersion, version) >= 0) continue;
                resourceVersion = version;
            }
            if (resourceVersion == null) {
                resourceVersion = "INVALID";
            }
        }
        return resourceVersion;
    }

    @Override
    public String getLibraryVersion(String path) {
        String libraryVersion = null;
        Set<String> libraryPaths = this.getResourcePaths((String)path);
        path = this.getPrefix() + "/" + (String)path;
        if (null != libraryPaths && !libraryPaths.isEmpty()) {
            for (String libraryPath : libraryPaths) {
                String version = libraryPath.substring(((String)path).length());
                if (!VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.length() - 1);
                if (libraryVersion == null) {
                    libraryVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(libraryVersion, version) >= 0) continue;
                libraryVersion = version;
            }
        }
        return libraryVersion;
    }

    @Override
    public URL getResourceURL(MockResourceMeta resourceMeta) {
        try {
            return FacesContext.getCurrentInstance().getExternalContext().getResource(this.getPrefix() + "/" + resourceMeta.getResourceIdentifier());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceInputStream(MockResourceMeta resourceMeta) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(this.getPrefix() + "/" + resourceMeta.getResourceIdentifier());
    }

    @Override
    public MockResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new MockResourceMeta(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    @Override
    public boolean libraryExists(String libraryName) {
        block7: {
            if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
                try {
                    URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(this.getPrefix() + "/" + libraryName);
                    if (url != null) {
                        return true;
                    }
                    break block7;
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }
            try {
                URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(libraryName);
                if (url != null) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }
}

