/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import jakarta.faces.application.Resource;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.myfaces.test.mock.resource.MockResourceHandlerSupport;
import org.apache.myfaces.test.mock.resource.MockResourceLoader;
import org.apache.myfaces.test.mock.resource.MockResourceMeta;

public class MockResource
extends Resource {
    private MockResourceMeta _resourceMeta;
    private MockResourceLoader _resourceLoader;
    private MockResourceHandlerSupport _resourceHandlerSupport;

    public MockResource(MockResourceMeta resourceMeta, MockResourceLoader resourceLoader, MockResourceHandlerSupport support, String contentType) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public MockResourceLoader getResourceLoader() {
        return this._resourceLoader;
    }

    public InputStream getInputStream() throws IOException {
        return this.getResourceLoader().getResourceInputStream(this._resourceMeta);
    }

    public String getRequestPath() {
        String path;
        if (this._resourceHandlerSupport.isExtensionMapping()) {
            path = "/jakarta.faces.resource/" + this.getResourceName() + this._resourceHandlerSupport.getMapping();
        } else {
            String mapping = this._resourceHandlerSupport.getMapping();
            path = "/jakarta.faces.resource/" + this.getResourceName();
            path = mapping == null ? path : mapping + path;
        }
        return path;
    }

    public Map<String, String> getResponseHeaders() {
        return Collections.emptyMap();
    }

    public URL getURL() {
        return this.getResourceLoader().getResourceURL(this._resourceMeta);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        return true;
    }
}

