/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import jakarta.faces.application.Resource;
import jakarta.faces.context.FacesContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.myfaces.test.mock.MockServletContext;

public class MockSimpleResource
extends Resource {
    private String _prefix;
    private String _libraryName;
    private String _libraryVersion;
    private String _resourceName;
    private String _resourceVersion;
    private File _documentRoot;

    public MockSimpleResource(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, File documentRoot) {
        this._prefix = prefix;
        this._libraryName = libraryName;
        this._libraryVersion = libraryVersion;
        this._resourceName = resourceName;
        this._resourceVersion = resourceVersion;
        this._documentRoot = documentRoot;
        if (this._documentRoot == null) {
            throw new IllegalArgumentException("documentRoot must not be null");
        }
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public void setResourceName(String resourceName) {
        this._resourceName = resourceName;
    }

    public String getLibraryName() {
        return this._libraryName;
    }

    public void setLibraryName(String libraryName) {
        this._libraryName = libraryName;
    }

    public InputStream getInputStream() throws IOException {
        MockServletContext servletContext = (MockServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        servletContext.setDocumentRoot(this._documentRoot);
        return servletContext.getResourceAsStream(this.buildResourcePath());
    }

    public String getRequestPath() {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public URL getURL() {
        MockServletContext servletContext = (MockServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        servletContext.setDocumentRoot(this._documentRoot);
        try {
            return servletContext.getResource(this.buildResourcePath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        return true;
    }

    private String buildResourcePath() {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        boolean firstSlashAdded = false;
        if (this._prefix != null && this._prefix.length() > 0) {
            builder.append(this._prefix);
            firstSlashAdded = true;
        }
        if (this._libraryName != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._libraryName);
            firstSlashAdded = true;
        }
        if (this._libraryVersion != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._libraryVersion);
            firstSlashAdded = true;
        }
        if (this._resourceName != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._resourceName);
            firstSlashAdded = true;
        }
        if (this._resourceVersion != null) {
            if (firstSlashAdded) {
                builder.append('/');
            }
            builder.append(this._resourceVersion);
            builder.append(this._resourceName.substring(this._resourceName.lastIndexOf(46)));
        }
        return builder.toString();
    }
}

