/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.resource;

import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.resource.MockSimpleResource;

public class MockSimpleResourceHandler
extends ResourceHandler {
    private static final String IS_RESOURCE_REQUEST = "org.apache.myfaces.IS_RESOURCE_REQUEST";
    protected static final Pattern VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*/");
    protected static final Pattern RESOURCE_VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*\\..*");
    private File _documentRoot;

    public MockSimpleResourceHandler(File documentRoot) {
        if (documentRoot == null) {
            throw new NullPointerException("documentRoot must not be null");
        }
        this._documentRoot = documentRoot;
        ((MockServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext()).setDocumentRoot(this._documentRoot);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        String prefix = this.getLocalePrefixForLocateResource();
        String libraryVersion = this.getLibraryVersion(prefix + "/" + libraryName);
        String pathToResource = null != libraryVersion ? prefix + "/" + libraryName + "/" + libraryVersion + "/" + resourceName : prefix + "/" + libraryName + "/" + resourceName;
        return new MockSimpleResource(prefix, libraryName, libraryVersion, resourceName, this.getResourceVersion(pathToResource), this._documentRoot);
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".js")) {
            return "jakarta.faces.resource.Script";
        }
        if (resourceName.endsWith(".css")) {
            return "jakarta.faces.resource.Stylesheet";
        }
        return null;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        Boolean value = (Boolean)facesContext.getExternalContext().getRequestMap().get(IS_RESOURCE_REQUEST);
        if (value != null && value.booleanValue()) {
            return value;
        }
        String resourceBasePath = facesContext.getExternalContext().getRequestPathInfo();
        if (resourceBasePath != null && resourceBasePath.startsWith("/jakarta.faces.resource")) {
            facesContext.getExternalContext().getRequestMap().put(IS_RESOURCE_REQUEST, Boolean.TRUE);
            return true;
        }
        facesContext.getExternalContext().getRequestMap().put(IS_RESOURCE_REQUEST, Boolean.FALSE);
        return false;
    }

    public boolean libraryExists(String libraryName) {
        String localePrefix = this.getLocalePrefixForLocateResource();
        Object pathToLib = localePrefix != null ? localePrefix + "/" + libraryName : libraryName;
        try {
            URL url = FacesContext.getCurrentInstance().getExternalContext().getResource("/" + (String)pathToLib);
            return url != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected String getLocalePrefixForLocateResource() {
        Locale locale;
        ResourceBundle bundle;
        String localePrefix = null;
        FacesContext context = FacesContext.getCurrentInstance();
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName && (bundle = ResourceBundle.getBundle(bundleName, locale = context.getApplication().getViewHandler().calculateLocale(context), MockSimpleResourceHandler.getContextClassLoader())) != null) {
            try {
                localePrefix = bundle.getString("jakarta.faces.resource.localePrefix");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
                return cl;
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException((Throwable)pae);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private String getLibraryVersion(String path) {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        String libraryVersion = null;
        Set libraryPaths = context.getResourcePaths("/" + path);
        if (null != libraryPaths && !libraryPaths.isEmpty()) {
            for (String libraryPath : libraryPaths) {
                String version = libraryPath.substring(path.length());
                if (!VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.length() - 1);
                if (libraryVersion == null) {
                    libraryVersion = version;
                    continue;
                }
                if (this.compareVersion(libraryVersion, version) >= 0) continue;
                libraryVersion = version;
            }
        }
        return libraryVersion;
    }

    private int compareVersion(String s1, String s2) {
        int n1 = 0;
        int n2 = 0;
        String o1 = s1;
        String o2 = s2;
        boolean p1 = true;
        boolean p2 = true;
        while (n1 == n2 && (p1 || p2)) {
            int i1 = o1.indexOf(95);
            int i2 = o2.indexOf(95);
            if (i1 < 0) {
                if (o1.length() > 0) {
                    p1 = false;
                    n1 = Integer.parseInt(o1);
                    o1 = "";
                } else {
                    p1 = false;
                    n1 = 0;
                }
            } else {
                n1 = Integer.valueOf(o1.substring(0, i1));
                o1 = o1.substring(i1 + 1);
            }
            if (i2 < 0) {
                if (o2.length() > 0) {
                    p2 = false;
                    n2 = Integer.valueOf(o2);
                    o2 = "";
                    continue;
                }
                p2 = false;
                n2 = 0;
                continue;
            }
            n2 = Integer.valueOf(o2.substring(0, i2));
            o2 = o2.substring(i2 + 1);
        }
        if (n1 == n2) {
            return s1.length() - s2.length();
        }
        return n1 - n2;
    }

    private String getResourceVersion(String path) {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        String resourceVersion = null;
        Set resourcePaths = context.getResourcePaths("/" + path);
        if (null != resourcePaths && !resourcePaths.isEmpty()) {
            for (String resourcePath : resourcePaths) {
                String version = resourcePath.substring(path.length());
                if (!RESOURCE_VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.lastIndexOf(46));
                if (resourceVersion == null) {
                    resourceVersion = version;
                    continue;
                }
                if (this.compareVersion(resourceVersion, version) >= 0) continue;
                resourceVersion = version;
            }
        }
        return resourceVersion;
    }
}

