/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.myfaces.tobago.maven.plugin.AbstractThemeMojo;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class IndexThemeMojo
extends AbstractThemeMojo {
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    private static final boolean FILE_SEPARATOR_IS_SLASH = FILE_SEPARATOR == '/';
    private static final String[] EXCLUDES = new String[]{"META-INF/**/*", "**/*.class"};
    private File outputDirectory;
    private File tobagoResourcesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block13: {
            block14: {
                if ("pom".equalsIgnoreCase(this.getProject().getPackaging())) {
                    this.getLog().info((CharSequence)("Not creating " + this.tobagoResourcesFile.getName() + " as the project is a pom package"));
                    return;
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Scanning resource: " + this.outputDirectory.getName()));
                }
                if (!this.outputDirectory.isAbsolute()) {
                    this.outputDirectory = new File(this.getProject().getBasedir(), this.outputDirectory.getPath());
                }
                if (!this.outputDirectory.exists()) {
                    this.getLog().info((CharSequence)("Not creating " + this.tobagoResourcesFile.getName() + " as the project has no outputDirectory"));
                    return;
                }
                StaleCheckDirectoryScanner scanner = new StaleCheckDirectoryScanner(this.tobagoResourcesFile.lastModified());
                scanner.setBasedir(this.outputDirectory);
                scanner.setIncludes(this.getIncludes());
                scanner.setExcludes(this.getExcludes());
                scanner.scan();
                String[] fileNames = scanner.getIncludedFiles();
                if (fileNames == null || fileNames.length == 0) {
                    this.getLog().info((CharSequence)("Skipping create resource file " + this.tobagoResourcesFile.getName() + ". No resources found"));
                    return;
                }
                if (scanner.isUp2date) break block14;
                File metaInf = this.tobagoResourcesFile.getParentFile();
                if (!metaInf.exists() && !metaInf.mkdirs()) {
                    this.getLog().error((CharSequence)("Error creating directory " + metaInf.getName()));
                }
                BufferedWriter bufferedWriter = null;
                try {
                    StringWriter stringWriter = new StringWriter();
                    bufferedWriter = new BufferedWriter(stringWriter);
                    for (String file : fileNames) {
                        bufferedWriter.append('/');
                        if (FILE_SEPARATOR_IS_SLASH) {
                            bufferedWriter.append(file);
                        } else {
                            bufferedWriter.append(this.convertFileSeparatorToSlash(file));
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                    FileUtils.fileWrite((File)this.tobagoResourcesFile, (String)"utf-8", (String)stringWriter.toString());
                }
                catch (IOException e) {
                    try {
                        this.getLog().error((CharSequence)("Error creating resource file " + this.tobagoResourcesFile.getName()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(bufferedWriter);
                        throw throwable;
                    }
                    IOUtil.close((Writer)bufferedWriter);
                    break block13;
                }
                IOUtil.close((Writer)bufferedWriter);
                break block13;
            }
            this.getLog().info((CharSequence)("Skipping create resource file " + this.tobagoResourcesFile.getName()));
        }
    }

    private String convertFileSeparatorToSlash(String file) {
        return file.replace(FILE_SEPARATOR, '/');
    }

    public String[] getExcludes() {
        return EXCLUDES;
    }

    private static class StaleCheckDirectoryScanner
    extends DirectoryScanner {
        private long lastModified;
        private boolean isUp2date = true;

        private StaleCheckDirectoryScanner(long lastModified) {
            this.lastModified = lastModified;
        }

        protected boolean isSelected(String name, File file) {
            long lastModified = file.lastModified();
            if (lastModified > this.lastModified) {
                this.isUp2date = false;
            }
            return super.isSelected(name, file);
        }
    }
}

