/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.util;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectItem;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.util.EncodeUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RenderUtils.class);
    @Deprecated
    public static final String COMPONENT_IN_REQUEST = "org.apache.myfaces.tobago.component";
    public static final String SCROLL_POSTFIX = "::scrollPosition";

    private RenderUtils() {
    }

    public static boolean contains(Object[] list, Object value) {
        if (list == null) {
            return false;
        }
        for (Object aList : list) {
            if (aList == null || !aList.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void encodeChildren(FacesContext facesContext, UIComponent panel) throws IOException {
        for (UIComponent child : panel.getChildren()) {
            RenderUtils.encode(facesContext, child);
        }
    }

    public static void encode(FacesContext facesContext, UIComponent component) throws IOException {
        RenderUtils.encode(facesContext, component, null);
    }

    public static void encode(FacesContext facesContext, UIComponent component, List<? extends Class<? extends UIComponent>> only) throws IOException {
        if (only != null && !RenderUtils.matchFilter(component, only)) {
            return;
        }
        if (component.isRendered()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("rendering " + component.getRendererType() + " " + component);
            }
            component.encodeBegin(facesContext);
            if (component.getRendersChildren()) {
                component.encodeChildren(facesContext);
            } else {
                for (UIComponent child : component.getChildren()) {
                    RenderUtils.encode(facesContext, child, only);
                }
            }
            component.encodeEnd(facesContext);
        }
    }

    private static boolean matchFilter(UIComponent component, List<? extends Class<? extends UIComponent>> only) {
        for (Class<? extends UIComponent> clazz : only) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void prepareRendererAll(FacesContext facesContext, UIComponent component) throws IOException {
        EncodeUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)component);
    }

    public static String getFormattedValue(FacesContext facesContext, UIComponent component) {
        Object value = null;
        if (component instanceof ValueHolder && (value = ((ValueHolder)component).getLocalValue()) == null) {
            value = ((ValueHolder)component).getValue();
        }
        return RenderUtils.getFormattedValue(facesContext, component, value);
    }

    public static String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return "";
        }
        if (!(component instanceof ValueHolder)) {
            return currentValue.toString();
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = context.getApplication().createConverter(converterType);
        }
        if (converter == null) {
            return currentValue.toString();
        }
        return converter.getAsString(context, component, currentValue);
    }

    public static Measure calculateStringWidth(FacesContext facesContext, UIComponent component, String text) {
        return RenderUtils.calculateStringWidth(facesContext, (Configurable)component, text, "tobago.font.widths");
    }

    public static Measure calculateStringWidth2(FacesContext facesContext, UIComponent component, String text) {
        return RenderUtils.calculateStringWidth(facesContext, (Configurable)component, text, "tobago.font2.widths");
    }

    private static Measure calculateStringWidth(FacesContext facesContext, Configurable component, String text, String type) {
        if (text == null) {
            return Measure.ZERO;
        }
        int width = 0;
        int defaultCharWidth = 10;
        try {
            defaultCharWidth = ResourceManagerUtils.getThemeMeasure((FacesContext)facesContext, (Configurable)component, (String)"fontWidth").getPixel();
        }
        catch (NullPointerException e) {
            LOG.warn("no value for 'fontWidth' for type '" + component.getRendererType() + "' found in theme-config");
        }
        String fontWidths = ResourceManagerUtils.getProperty((FacesContext)facesContext, (String)"tobago", (String)type);
        for (char c : text.toCharArray()) {
            if (c >= ' ' && c < '\u0080') {
                int begin = (c - 32) * 2;
                width += Integer.parseInt(fontWidths.substring(begin, begin + 2), 16);
                continue;
            }
            width += defaultCharWidth;
        }
        return Measure.valueOf((int)(width += text.length()));
    }

    @Deprecated
    public static List<SelectItem> getItemsToRender(UISelectOne component) {
        return RenderUtils.getItems((UIInput)component);
    }

    @Deprecated
    public static List<SelectItem> getItemsToRender(UISelectMany component) {
        return RenderUtils.getItems((UIInput)component);
    }

    @Deprecated
    public static List<SelectItem> getItems(UIInput component) {
        List<SelectItem> selectItems = RenderUtils.getSelectItems((UIComponent)component);
        String renderRange = (String)component.getAttributes().get("renderRangeExtern");
        if (renderRange == null) {
            renderRange = (String)component.getAttributes().get("renderRange");
        }
        if (renderRange == null) {
            return selectItems;
        }
        int[] indices = StringUtils.getIndices((String)renderRange);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(indices.length);
        if (selectItems.size() != 0) {
            for (int index : indices) {
                items.add(selectItems.get(index));
            }
        } else {
            LOG.warn("No items found! rendering dummies instead!");
            for (int i = 0; i < indices.length; ++i) {
                items.add(new SelectItem((Object)Integer.toString(i), "Item " + i, ""));
            }
        }
        return items;
    }

    public static String currentValue(UIComponent component) {
        String currentValue = null;
        if (component instanceof ValueHolder) {
            Object value;
            if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return (String)value;
            }
            value = ((ValueHolder)component).getValue();
            if (value != null) {
                Converter converter = ((ValueHolder)component).getConverter();
                if (converter == null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    converter = context.getApplication().createConverter(value.getClass());
                }
                currentValue = converter != null ? converter.getAsString(FacesContext.getCurrentInstance(), component, value) : value.toString();
            }
        }
        return currentValue;
    }

    @Deprecated
    public static List<SelectItem> getSelectItems(UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            String message;
            Object value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("kid " + child);
                LOG.debug("kid " + child.getClass().getName());
            }
            if (child instanceof javax.faces.component.UISelectItem) {
                value = ((javax.faces.component.UISelectItem)child).getValue();
                if (value == null) {
                    javax.faces.component.UISelectItem item = (javax.faces.component.UISelectItem)child;
                    if (child instanceof UISelectItem) {
                        list.add(RenderUtils.getSelectItem((UISelectItem)child));
                        continue;
                    }
                    list.add(new SelectItem(item.getItemValue() == null ? "" : item.getItemValue(), item.getItemLabel() != null ? item.getItemLabel() : item.getItemValue().toString(), item.getItemDescription()));
                    continue;
                }
                if (value instanceof SelectItem) {
                    list.add((SelectItem)value);
                    continue;
                }
                message = "TYPE ERROR: value NOT instanceof SelectItem. type=" + value.getClass().getName() + " value=" + value;
                LOG.error(message);
                DebugUtils.addDevelopmentMessage((FacesContext)FacesContext.getCurrentInstance(), (String)message);
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            value = ((UISelectItems)child).getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("value " + value);
                if (value != null) {
                    LOG.debug("value " + value.getClass().getName());
                }
            }
            if (value == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("value is null");
                continue;
            }
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                SelectItem[] items = (SelectItem[])value;
                list.addAll(Arrays.asList(items));
                continue;
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    list.add((SelectItem)o);
                }
                continue;
            }
            if (value instanceof Map) {
                for (Object key : ((Map)value).keySet()) {
                    Object val;
                    if (key == null || (val = ((Map)value).get(key)) == null) continue;
                    list.add(new SelectItem((Object)val.toString(), key.toString(), null));
                }
                continue;
            }
            message = "TYPE ERROR: value NOT instanceof SelectItem, SelectItem[], Collection, Map. type=" + value.getClass().getName() + " value=" + value;
            LOG.error(message);
            DebugUtils.addDevelopmentMessage((FacesContext)FacesContext.getCurrentInstance(), (String)message);
        }
        return list;
    }

    @Deprecated
    private static SelectItem getSelectItem(UISelectItem component) {
        return new org.apache.myfaces.tobago.model.SelectItem(component.getItemValue() == null ? "" : component.getItemValue(), component.getItemLabel(), component.getItemDescription(), component.isItemDisabled(), component.getItemImage(), component.getMarkup());
    }

    public static void decodedStateOfTreeData(FacesContext facesContext, AbstractUIData data) {
        if (!data.isTreeModel()) {
            return;
        }
        List<Integer> selectedIndices = RenderUtils.decodeIndices(facesContext, data, "selected");
        List<Integer> expandedIndices = RenderUtils.decodeIndices(facesContext, data, "expanded");
        int last = data.isRowsUnlimited() ? Integer.MAX_VALUE : data.getFirst() + data.getRows();
        for (int rowIndex = data.getFirst(); rowIndex < last; ++rowIndex) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            TreePath path = data.getPath();
            if (selectedIndices != null) {
                SelectedState selectedState = data.getSelectedState();
                boolean oldSelected = selectedState.isSelected(path);
                boolean newSelected = selectedIndices.contains(rowIndex);
                if (newSelected != oldSelected) {
                    if (newSelected) {
                        selectedState.select(path);
                    } else {
                        selectedState.unselect(path);
                    }
                }
            }
            if (expandedIndices == null || expandedIndices == null) continue;
            ExpandedState expandedState = data.getExpandedState();
            boolean oldExpanded = expandedState.isExpanded(path);
            boolean newExpanded = expandedIndices.contains(rowIndex);
            if (newExpanded == oldExpanded) continue;
            if (newExpanded) {
                expandedState.expand(path);
                continue;
            }
            expandedState.collapse(path);
        }
        data.setRowIndex(-1);
    }

    private static List<Integer> decodeIndices(FacesContext facesContext, AbstractUIData data, String suffix) {
        String string = null;
        String key = data.getClientId(facesContext) + "::" + suffix;
        try {
            string = (String)facesContext.getExternalContext().getRequestParameterMap().get(key);
            if (string != null) {
                return StringUtils.parseIntegerList((String)string);
            }
        }
        catch (Exception e) {
            LOG.warn("Can't parse " + suffix + ": '" + string + "' from parameter '" + key + "'", (Throwable)e);
        }
        return null;
    }

    public static void writeScrollPosition(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        Integer[] scrollPosition = (Integer[])component.getAttributes().get("attrScrollPosition");
        if (scrollPosition == null) {
            String key = component.getClientId(facesContext) + SCROLL_POSTFIX;
            scrollPosition = RenderUtils.parseScrollPosition((String)facesContext.getExternalContext().getRequestParameterMap().get(key));
        }
        RenderUtils.writeScrollPosition(facesContext, writer, component, scrollPosition);
    }

    public static void writeScrollPosition(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component, Integer[] scrollPosition) throws IOException {
        String clientId = component.getClientId(facesContext);
        writer.startElement("input", null);
        writer.writeIdAttribute(clientId + SCROLL_POSTFIX);
        writer.writeNameAttribute(clientId + SCROLL_POSTFIX);
        writer.writeAttribute("type", "hidden", false);
        String scrollPositionString = scrollPosition != null ? scrollPosition[0] + ";" + scrollPosition[1] : "";
        writer.writeAttribute("value", scrollPositionString, false);
        writer.writeAttribute("data-tobago-scroll-position", "true", true);
        writer.endElement("input");
    }

    public static void decodeScrollPosition(FacesContext facesContext, UIComponent component) {
        Integer[] scrollPosition;
        String key = component.getClientId(facesContext) + SCROLL_POSTFIX;
        String value = (String)facesContext.getExternalContext().getRequestParameterMap().get(key);
        if (value != null && (scrollPosition = RenderUtils.parseScrollPosition(value)) != null) {
            component.getAttributes().put("attrScrollPosition", scrollPosition);
        }
    }

    public static Integer[] parseScrollPosition(String value) {
        Integer[] position = null;
        if (!StringUtils.isBlank((String)value)) {
            int sep = value.indexOf(";");
            if (sep == -1) {
                LOG.warn("Can't parse: '{}'", (Object)value);
                return null;
            }
            int left = Integer.parseInt(value.substring(0, sep));
            int top = Integer.parseInt(value.substring(sep + 1));
            position = new Integer[]{left, top};
        }
        return position;
    }

    public static String generateUrl(FacesContext facesContext, AbstractUICommand component) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        ExternalContext externalContext = facesContext.getExternalContext();
        String url = null;
        if (component.getResource() != null) {
            boolean jsfResource = component.isJsfResource();
            url = ResourceManagerUtils.getPageWithoutContextPath((FacesContext)facesContext, (String)component.getResource());
            if (url != null) {
                if (jsfResource) {
                    url = viewHandler.getActionURL(facesContext, url);
                    url = externalContext.encodeActionURL(url);
                } else {
                    url = viewHandler.getResourceURL(facesContext, url);
                    url = externalContext.encodeResourceURL(url);
                }
            } else {
                url = "";
            }
        } else if (component.getLink() != null) {
            String link = component.getLink();
            url = link.startsWith("/") ? externalContext.encodeResourceURL(externalContext.getRequestContextPath() + link) : (StringUtils.isUrl((String)link) ? link : externalContext.encodeResourceURL(link));
            StringBuilder builder = new StringBuilder(url);
            boolean firstParameter = !url.contains("?");
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                if (firstParameter) {
                    builder.append("?");
                    firstParameter = false;
                } else {
                    builder.append("&");
                }
                builder.append(parameter.getName());
                builder.append("=");
                Object value = parameter.getValue();
                builder.append(value != null ? URLDecoder.decode(value.toString()) : null);
            }
            url = builder.toString();
        }
        return url;
    }
}

