/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.layout;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.layout.AbstractHtmlPanelLayout.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlPanelLayout extends org.apache.myfaces.custom.layout.AbstractHtmlPanelLayout
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Panel";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlPanelLayout";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.Layout";


    public HtmlPanelLayout()
    {
        setRendererType("org.apache.myfaces.Layout");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }


    static private final java.util.Collection<String> CLIENT_EVENTS_LIST = 
        java.util.Collections.unmodifiableCollection(
            java.util.Arrays.asList(
             "click"
            , "dblclick"
            , "keydown"
            , "keypress"
            , "keyup"
            , "mousedown"
            , "mousemove"
            , "mouseout"
            , "mouseover"
            , "mouseup"
        ));

    public java.util.Collection<String> getEventNames()
    {
        return CLIENT_EVENTS_LIST;
    }

    
    // Property: footerClass
    public String getFooterClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.footerClass);
    }
    
    public void setFooterClass(String footerClass)
    {
        getStateHelper().put(PropertyKeys.footerClass, footerClass ); 
    }    
    // Property: headerClass
    public String getHeaderClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.headerClass);
    }
    
    public void setHeaderClass(String headerClass)
    {
        getStateHelper().put(PropertyKeys.headerClass, headerClass ); 
    }    
    // Property: layout
    public String getLayout()
    {
        return (String) getStateHelper().eval(PropertyKeys.layout, "classic");
    }
    
    public void setLayout(String layout)
    {
        getStateHelper().put(PropertyKeys.layout, layout ); 
    }    
    // Property: navigationClass
    public String getNavigationClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.navigationClass);
    }
    
    public void setNavigationClass(String navigationClass)
    {
        getStateHelper().put(PropertyKeys.navigationClass, navigationClass ); 
    }    
    // Property: bodyClass
    public String getBodyClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.bodyClass);
    }
    
    public void setBodyClass(String bodyClass)
    {
        getStateHelper().put(PropertyKeys.bodyClass, bodyClass ); 
    }    
    // Property: headerStyle
    public String getHeaderStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.headerStyle);
    }
    
    public void setHeaderStyle(String headerStyle)
    {
        getStateHelper().put(PropertyKeys.headerStyle, headerStyle ); 
    }    
    // Property: navigationStyle
    public String getNavigationStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.navigationStyle);
    }
    
    public void setNavigationStyle(String navigationStyle)
    {
        getStateHelper().put(PropertyKeys.navigationStyle, navigationStyle ); 
    }    
    // Property: bodyStyle
    public String getBodyStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.bodyStyle);
    }
    
    public void setBodyStyle(String bodyStyle)
    {
        getStateHelper().put(PropertyKeys.bodyStyle, bodyStyle ); 
    }    
    // Property: footerStyle
    public String getFooterStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.footerStyle);
    }
    
    public void setFooterStyle(String footerStyle)
    {
        getStateHelper().put(PropertyKeys.footerStyle, footerStyle ); 
    }    
    // Property: dir
    public String getDir()
    {
        return (String) getStateHelper().eval(PropertyKeys.dir);
    }
    
    public void setDir(String dir)
    {
        getStateHelper().put(PropertyKeys.dir, dir ); 
    }    
    // Property: lang
    public String getLang()
    {
        return (String) getStateHelper().eval(PropertyKeys.lang);
    }
    
    public void setLang(String lang)
    {
        getStateHelper().put(PropertyKeys.lang, lang ); 
    }    
    // Property: title
    public String getTitle()
    {
        return (String) getStateHelper().eval(PropertyKeys.title);
    }
    
    public void setTitle(String title)
    {
        getStateHelper().put(PropertyKeys.title, title ); 
    }    
    // Property: align
    public String getAlign()
    {
        return (String) getStateHelper().eval(PropertyKeys.align);
    }
    
    public void setAlign(String align)
    {
        getStateHelper().put(PropertyKeys.align, align ); 
    }    
    // Property: onclick
    public String getOnclick()
    {
        return (String) getStateHelper().eval(PropertyKeys.onclick);
    }
    
    public void setOnclick(String onclick)
    {
        getStateHelper().put(PropertyKeys.onclick, onclick ); 
    }    
    // Property: ondblclick
    public String getOndblclick()
    {
        return (String) getStateHelper().eval(PropertyKeys.ondblclick);
    }
    
    public void setOndblclick(String ondblclick)
    {
        getStateHelper().put(PropertyKeys.ondblclick, ondblclick ); 
    }    
    // Property: onkeydown
    public String getOnkeydown()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown)
    {
        getStateHelper().put(PropertyKeys.onkeydown, onkeydown ); 
    }    
    // Property: onkeypress
    public String getOnkeypress()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress)
    {
        getStateHelper().put(PropertyKeys.onkeypress, onkeypress ); 
    }    
    // Property: onkeyup
    public String getOnkeyup()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup)
    {
        getStateHelper().put(PropertyKeys.onkeyup, onkeyup ); 
    }    
    // Property: onmousedown
    public String getOnmousedown()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown)
    {
        getStateHelper().put(PropertyKeys.onmousedown, onmousedown ); 
    }    
    // Property: onmousemove
    public String getOnmousemove()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove)
    {
        getStateHelper().put(PropertyKeys.onmousemove, onmousemove ); 
    }    
    // Property: onmouseout
    public String getOnmouseout()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout)
    {
        getStateHelper().put(PropertyKeys.onmouseout, onmouseout ); 
    }    
    // Property: onmouseover
    public String getOnmouseover()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover)
    {
        getStateHelper().put(PropertyKeys.onmouseover, onmouseover ); 
    }    
    // Property: onmouseup
    public String getOnmouseup()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup)
    {
        getStateHelper().put(PropertyKeys.onmouseup, onmouseup ); 
    }    
    // Property: bgcolor
    public String getBgcolor()
    {
        return (String) getStateHelper().eval(PropertyKeys.bgcolor);
    }
    
    public void setBgcolor(String bgcolor)
    {
        getStateHelper().put(PropertyKeys.bgcolor, bgcolor ); 
    }    
    // Property: border
    public int getBorder()
    {
        return (Integer) getStateHelper().eval(PropertyKeys.border, Integer.MIN_VALUE);
    }
    
    public void setBorder(int border)
    {
        getStateHelper().put(PropertyKeys.border, border ); 
    }    
    // Property: cellpadding
    public String getCellpadding()
    {
        return (String) getStateHelper().eval(PropertyKeys.cellpadding);
    }
    
    public void setCellpadding(String cellpadding)
    {
        getStateHelper().put(PropertyKeys.cellpadding, cellpadding ); 
    }    
    // Property: cellspacing
    public String getCellspacing()
    {
        return (String) getStateHelper().eval(PropertyKeys.cellspacing);
    }
    
    public void setCellspacing(String cellspacing)
    {
        getStateHelper().put(PropertyKeys.cellspacing, cellspacing ); 
    }    
    // Property: frame
    public String getFrame()
    {
        return (String) getStateHelper().eval(PropertyKeys.frame);
    }
    
    public void setFrame(String frame)
    {
        getStateHelper().put(PropertyKeys.frame, frame ); 
    }    
    // Property: rules
    public String getRules()
    {
        return (String) getStateHelper().eval(PropertyKeys.rules);
    }
    
    public void setRules(String rules)
    {
        getStateHelper().put(PropertyKeys.rules, rules ); 
    }    
    // Property: summary
    public String getSummary()
    {
        return (String) getStateHelper().eval(PropertyKeys.summary);
    }
    
    public void setSummary(String summary)
    {
        getStateHelper().put(PropertyKeys.summary, summary ); 
    }    
    // Property: width
    public String getWidth()
    {
        return (String) getStateHelper().eval(PropertyKeys.width);
    }
    
    public void setWidth(String width)
    {
        getStateHelper().put(PropertyKeys.width, width ); 
    }    
    // Property: datafld
    public String getDatafld()
    {
        return (String) getStateHelper().eval(PropertyKeys.datafld);
    }
    
    public void setDatafld(String datafld)
    {
        getStateHelper().put(PropertyKeys.datafld, datafld ); 
    }    
    // Property: datasrc
    public String getDatasrc()
    {
        return (String) getStateHelper().eval(PropertyKeys.datasrc);
    }
    
    public void setDatasrc(String datasrc)
    {
        getStateHelper().put(PropertyKeys.datasrc, datasrc ); 
    }    
    // Property: dataformatas
    public String getDataformatas()
    {
        return (String) getStateHelper().eval(PropertyKeys.dataformatas);
    }
    
    public void setDataformatas(String dataformatas)
    {
        getStateHelper().put(PropertyKeys.dataformatas, dataformatas ); 
    }    

    protected enum PropertyKeys
    {
         footerClass
        , headerClass
        , layout
        , navigationClass
        , bodyClass
        , headerStyle
        , navigationStyle
        , bodyStyle
        , footerStyle
        , dir
        , lang
        , title
        , align
        , onclick
        , ondblclick
        , onkeydown
        , onkeypress
        , onkeyup
        , onmousedown
        , onmousemove
        , onmouseout
        , onmouseover
        , onmouseup
        , bgcolor
        , border
        , cellpadding
        , cellspacing
        , frame
        , rules
        , summary
        , width
        , datafld
        , datasrc
        , dataformatas
    }

 }
