/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlOutcomeTargetButton;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.apache.myfaces.shared_tomahawk.renderkit.ClientBehaviorEvents;
import org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

/**
 * @since 2.0
 * @author Leonardo Uribe (latest modification by $Author: lu4242 $)
 * @version $Revision: 980254 $ $Date: 2010-07-28 22:31:41 +0000 (Wed, 28 Jul 2010) $
 */
public class HtmlOutcomeTargetButtonRendererBase extends HtmlRenderer
{

    public boolean getRendersChildren()
    {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent)
            throws IOException
    {
        super.encodeBegin(facesContext, uiComponent); //check for NP

        String clientId = uiComponent.getClientId(facesContext);

        ResponseWriter writer = facesContext.getResponseWriter();

        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder)
        {
            behaviors = ((ClientBehaviorHolder) uiComponent).getClientBehaviors();
            if (!behaviors.isEmpty())
            {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
            }
        }

        writer.startElement(HTML.INPUT_ELEM, uiComponent);

        writer.writeAttribute(HTML.ID_ATTR, clientId,
                org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr.ID_ATTR);
        writer.writeAttribute(HTML.NAME_ATTR, clientId, JSFAttr.ID_ATTR);

        String image = getImage(uiComponent);

        ExternalContext externalContext = facesContext.getExternalContext();

        if (image != null)
        {
            writer.writeAttribute(HTML.TYPE_ATTR, HTML.INPUT_TYPE_IMAGE,
                    org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr.TYPE_ATTR);
            String src = facesContext.getApplication().getViewHandler()
                    .getResourceURL(facesContext, image);
            writer.writeURIAttribute(HTML.SRC_ATTR, externalContext
                    .encodeResourceURL(src),
                    org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr.IMAGE_ATTR);
        }
        else
        {
            writer.writeAttribute(HTML.TYPE_ATTR, HTML.INPUT_TYPE_BUTTON,
                    org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr.TYPE_ATTR);
            Object value = org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils
                    .getStringValue(facesContext, uiComponent);
            if (value != null)
            {
                writer
                        .writeAttribute(
                                org.apache.myfaces.shared_tomahawk.renderkit.html.HTML.VALUE_ATTR,
                                value,
                                org.apache.myfaces.shared_tomahawk.renderkit.JSFAttr.VALUE_ATTR);
            }
        }

        if (HtmlRendererUtils.isDisabled(uiComponent))
        {
            HtmlRendererUtils.renderHTMLAttribute(writer, HTML.DISABLED_ATTR,
                    HTML.DISABLED_ATTR, true);
        }
        else
        {
            String href = facesContext.getExternalContext().encodeResourceURL(
                    HtmlRendererUtils.getOutcomeTargetLinkHref(facesContext,
                            (UIOutcomeTarget) uiComponent));

            if (behaviors != null && !behaviors.isEmpty())
            {
                HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, HTML.ONCLICK_ATTR, 
                        uiComponent, ClientBehaviorEvents.CLICK, null, behaviors, HTML.ONCLICK_ATTR, 
                        (String) uiComponent.getAttributes().get(HTML.ONCLICK_ATTR), "window.location.href = '" + href + "'");
            }
            else
            {
                String commandOnClick = (String) uiComponent.getAttributes().get(
                        HTML.ONCLICK_ATTR);
                StringBuffer onClick = new StringBuffer();
    
                if (commandOnClick != null)
                {
                    onClick.append(commandOnClick);
                    onClick.append(';');
                }
    
                onClick.append("window.location.href = '" + href + "'");
    
                writer.writeAttribute(HTML.ONCLICK_ATTR, onClick.toString(), null);
            }
        }

        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext()))
        {
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
        }
        else
        {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent,
                    HTML.EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK);
            HtmlRendererUtils
                .renderHTMLAttributes(
                    writer,
                    uiComponent,
                    HTML.COMMON_FIELD_EVENT_ATTRIBUTES_WITHOUT_ONSELECT_AND_ONCHANGE);

        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent,
                HTML.COMMON_FIELD_PASSTROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent,
                HTML.ALT_ATTR, HTML.ALT_ATTR);

        writer.flush();
    }

    private String getImage(UIComponent uiComponent)
    {
        if (uiComponent instanceof HtmlOutcomeTargetButton)
        {
            return ((HtmlOutcomeTargetButton) uiComponent).getImage();
        }
        return (String) uiComponent.getAttributes().get(JSFAttr.IMAGE_ATTR);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component)
            throws IOException
    {
        RendererUtils.renderChildren(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component)
            throws IOException
    {
        super.encodeEnd(facesContext, component); //check for NP

        ResponseWriter writer = facesContext.getResponseWriter();

        writer.endElement(HTML.INPUT_ELEM);
    }
}
