/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.application;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared_tomahawk.application.FacesServletMapping;
import org.apache.myfaces.shared_tomahawk.application.InvalidViewIdException;
import org.apache.myfaces.shared_tomahawk.application.ViewHandlerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewHandlerSupport
implements ViewHandlerSupport {
    private static final String CACHED_SERVLET_MAPPING = DefaultViewHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private static final Logger log = Logger.getLogger(DefaultViewHandlerSupport.class.getName());
    private static final String CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE";
    private static final int CHECKED_VIEWID_CACHE_DEFAULT_SIZE = 500;
    private static final String CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE = "org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED";
    private static final boolean CHECKED_VIEWID_CACHE_ENABLED_DEFAULT = true;
    private Map<String, Boolean> _checkedViewIdMap = null;
    private Boolean _checkedViewIdCacheEnabled = null;

    @Override
    public String calculateViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            viewId = this.handlePrefixMapping(viewId, mapping.getPrefix());
        } else if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    @Override
    public String calculateAndCheckViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null) {
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        } else {
            if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
                throw new InvalidViewIdException(viewId);
            }
            if (viewId != null) {
                return this.checkResourceExists(context, viewId) ? viewId : null;
            }
        }
        return viewId;
    }

    @Override
    public String calculateActionURL(FacesContext context, String viewId) {
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("ViewId must start with a '/': " + viewId);
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        StringBuilder builder = new StringBuilder(contextPath);
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                String[] contextSuffixes = this.getContextSuffix(context);
                boolean founded = false;
                for (String contextSuffix : contextSuffixes) {
                    if (!viewId.endsWith(contextSuffix)) continue;
                    builder.append(viewId.substring(0, viewId.indexOf(contextSuffix)));
                    builder.append(mapping.getExtension());
                    founded = true;
                    break;
                }
                if (!founded) {
                    if (viewId.lastIndexOf(".") != -1) {
                        builder.append(viewId.substring(0, viewId.lastIndexOf(".")));
                    } else {
                        builder.append(viewId);
                    }
                    builder.append(contextSuffixes[0]);
                }
            } else {
                builder.append(mapping.getPrefix());
                builder.append(viewId);
            }
        } else {
            builder.append(viewId);
        }
        String calculatedActionURL = builder.toString();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Calculated actionURL: '" + calculatedActionURL + "' for viewId: '" + viewId + "'");
        }
        return calculatedActionURL;
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (!requestMap.containsKey(CACHED_SERVLET_MAPPING)) {
            ExternalContext externalContext = context.getExternalContext();
            FacesServletMapping mapping = DefaultViewHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            requestMap.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return (FacesServletMapping)requestMap.get(CACHED_SERVLET_MAPPING);
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .jsp";
        }
        return defaultSuffix.split(" ");
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEWMAPPINGS");
        }
        return faceletsViewMappings == null ? null : faceletsViewMappings.split(";");
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        String uri = viewId;
        prefix = prefix + '/';
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            if (uri.startsWith(prefix)) {
                uri = uri.substring(prefix.length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String[] faceletsViewMappings = this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        for (String defaultSuffix : jspDefaultSuffixes) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                for (String mapping : faceletsViewMappings) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.checkResourceExists(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.checkResourceExists(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String faceletsDefaultSuffix = this.getFaceletsContextSuffix(context);
        if (faceletsDefaultSuffix != null) {
            for (String defaultSuffix : jspDefaultSuffixes) {
                if (!faceletsDefaultSuffix.equals(defaultSuffix)) continue;
                faceletsDefaultSuffix = null;
                break;
            }
        }
        if (faceletsDefaultSuffix != null) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext context, String viewId) {
        try {
            if (this.isCheckedViewIdCachingEnabled(context)) {
                Boolean resourceExists = this.getCheckedViewIDMap(context).get(viewId);
                if (resourceExists == null) {
                    resourceExists = context.getExternalContext().getResource(viewId) != null;
                    this.getCheckedViewIDMap(context).put(viewId, resourceExists);
                }
                return resourceExists;
            }
            if (context.getExternalContext().getResource(viewId) != null) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    private Map<String, Boolean> getCheckedViewIDMap(FacesContext context) {
        if (this._checkedViewIdMap == null) {
            this._checkedViewIdMap = Collections.synchronizedMap(new _CheckedViewIDMap(this.getViewIDCacheMaxSize(context)));
        }
        return this._checkedViewIdMap;
    }

    private boolean isCheckedViewIdCachingEnabled(FacesContext context) {
        if (this._checkedViewIdCacheEnabled == null) {
            if (!context.isProjectStage(ProjectStage.Production)) {
                this._checkedViewIdCacheEnabled = Boolean.FALSE;
                return this._checkedViewIdCacheEnabled;
            }
            String configParam = context.getExternalContext().getInitParameter(CHECKED_VIEWID_CACHE_ENABLED_ATTRIBUTE);
            this._checkedViewIdCacheEnabled = configParam == null ? true : Boolean.parseBoolean(configParam);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "MyFaces ViewID Caching Enabled=" + this._checkedViewIdCacheEnabled);
            }
        }
        return this._checkedViewIdCacheEnabled;
    }

    private int getViewIDCacheMaxSize(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String configParam = externalContext == null ? null : externalContext.getInitParameter(CHECKED_VIEWID_CACHE_SIZE_ATTRIBUTE);
        return configParam == null ? 500 : Integer.parseInt(configParam);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _CheckedViewIDMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int maxCapacity;

        public _CheckedViewIDMap(int cacheSize) {
            super(cacheSize + 1, 1.1f, true);
            this.maxCapacity = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCapacity;
        }
    }
}

