/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.util;

import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;

public class TomahawkResourceUtils {
    public static final String HEAD_LOCATION = "head";
    public static final String BODY_LOCATION = "body";
    public static final String FORM_LOCATION = "form";

    public static void addOutputScriptResource(FacesContext facesContext, String libraryName, String resourceName) {
        UIOutput outputScript = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Script");
        outputScript.getAttributes().put("library", libraryName);
        outputScript.getAttributes().put("name", resourceName);
        outputScript.setTransient(true);
        outputScript.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputScript);
    }

    public static void addOutputStylesheetResource(FacesContext facesContext, String libraryName, String resourceName) {
        UIOutput outputStylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Stylesheet");
        outputStylesheet.getAttributes().put("library", libraryName);
        outputStylesheet.getAttributes().put("name", resourceName);
        outputStylesheet.setTransient(true);
        outputStylesheet.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputStylesheet);
    }

    public static void addInlineOutputStylesheetResource(FacesContext facesContext, Object value) {
        UIOutput stylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.Text");
        UIOutput outputStylesheet = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Stylesheet");
        stylesheet.setValue(value);
        stylesheet.setTransient(true);
        stylesheet.setId(facesContext.getViewRoot().createUniqueId());
        outputStylesheet.getChildren().add(stylesheet);
        outputStylesheet.setTransient(true);
        outputStylesheet.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputStylesheet);
    }

    public static void addInlineOutputScriptResource(FacesContext facesContext, String target, Object value) {
        UIOutput script = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.Text");
        UIOutput outputScript = (UIOutput)facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Script");
        if (target != null) {
            script.getAttributes().put("target", target);
        }
        script.setValue(value);
        script.setTransient(true);
        script.setId(facesContext.getViewRoot().createUniqueId());
        outputScript.getChildren().add(script);
        outputScript.setTransient(true);
        outputScript.setId(facesContext.getViewRoot().createUniqueId());
        facesContext.getViewRoot().addComponentResource(facesContext, (UIComponent)outputScript);
    }

    public static String getIconSrc(FacesContext facesContext, String libraryName, String resourceName) {
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource resource = libraryName != null && libraryName.length() > 0 ? resourceHandler.createResource(resourceName, libraryName) : resourceHandler.createResource(resourceName);
        if (resource == null) {
            return "RES_NOT_FOUND";
        }
        return resource.getRequestPath();
    }
}

