/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemHeadersSupport;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.fileupload.portlet.PortletRequestContext;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;

public class PortletChacheFileSizeErrorsFileUpload
extends PortletFileUpload {
    public PortletChacheFileSizeErrorsFileUpload() {
    }

    public PortletChacheFileSizeErrorsFileUpload(FileItemFactory fileItemFactory) {
        super(fileItemFactory);
    }

    private long getContentLength(FileItemHeaders pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader("Content-length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public List parseRequestCatchingFileSizeErrors(ActionRequest request, FileUpload fileUpload) throws FileUploadException {
        try {
            ArrayList<FileItem> items = new ArrayList<FileItem>();
            FileItemIterator iter = fileUpload.getItemIterator((RequestContext)new PortletRequestContext(request));
            FileItemFactory fac = fileUpload.getFileItemFactory();
            if (fac == null) {
                throw new NullPointerException("No FileItemFactory has been set.");
            }
            long maxFileSize = this.getFileSizeMax();
            long maxSize = this.getSizeMax();
            boolean checkMaxSize = false;
            if (maxFileSize == -1L) {
                maxFileSize = maxSize;
            }
            if (maxSize != -1L) {
                checkMaxSize = true;
            }
            while (iter.hasNext()) {
                final FileItemStream item = iter.next();
                FileItem fileItem = fac.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), item.getName());
                long allowedLimit = 0L;
                try {
                    if (maxFileSize != -1L || checkMaxSize) {
                        allowedLimit = checkMaxSize ? (maxSize > maxFileSize ? maxFileSize : maxSize) : maxFileSize;
                        long contentLength = this.getContentLength(item.getHeaders());
                        if (contentLength != -1L && contentLength > allowedLimit) {
                            throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted " + " size of " + allowedLimit + " characters.", contentLength, allowedLimit));
                        }
                        InputStream itemInputStream = item.openStream();
                        LimitedInputStream limitedInputStream = new LimitedInputStream(itemInputStream, allowedLimit){

                            protected void raiseError(long pSizeMax, long pCount) throws IOException {
                                throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.FileSizeLimitExceededException("The field " + item.getFieldName() + " exceeds its maximum permitted " + " size of " + pSizeMax + " characters.", pCount, pSizeMax));
                            }
                        };
                        long bytesCopied = Streams.copy((InputStream)limitedInputStream, (OutputStream)fileItem.getOutputStream(), (boolean)true);
                        maxSize -= bytesCopied;
                    } else {
                        Streams.copy((InputStream)item.openStream(), (OutputStream)fileItem.getOutputStream(), (boolean)true);
                    }
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    try {
                        throw (FileUploadException)e.getCause();
                    }
                    catch (FileUploadBase.FileSizeLimitExceededException se) {
                        request.setAttribute("org.apache.myfaces.custom.fileupload.exception", (Object)"fileSizeLimitExceeded");
                        String fieldName = fileItem.getFieldName();
                        request.setAttribute("org.apache.myfaces.custom.fileupload." + fieldName + ".maxSize", (Object)new Integer((int)allowedLimit));
                    }
                }
                catch (IOException e) {
                    throw new FileUploadBase.IOFileUploadException("Processing of multipart/form-data request failed. " + e.getMessage(), e);
                }
                if (fileItem instanceof FileItemHeadersSupport) {
                    FileItemHeaders fih = item.getHeaders();
                    ((FileItemHeadersSupport)fileItem).setHeaders(fih);
                }
                if (fileItem == null) continue;
                items.add(fileItem);
            }
            return items;
        }
        catch (FileUploadBase.FileUploadIOException e) {
            throw (FileUploadException)e.getCause();
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), (Throwable)e);
        }
    }
}

