/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.component.html.ext._SerializableDataModel;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.custom.ExtendedComponentBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlDataTableHack
extends HtmlDataTable
implements ExtendedComponentBase {
    private Map<String, DataModel> _dataModelMap = new HashMap<String, DataModel>();
    private boolean _isValidChilds = true;
    private Map<String, Object> _rowStates = new HashMap<String, Object>();
    private Map<String, Map<String, Object>> _rowDeltaStates = new HashMap<String, Map<String, Object>>();
    private Object _initialDescendantComponentState = null;
    private Object _initialDescendantFullComponentState = null;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final boolean DEFAULT_PRESERVEROWSTATES = false;
    private int _rowIndex = -1;
    private static final DataModel EMPTY_DATA_MODEL = new _SerializableDataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IndexOutOfBoundsException("Index < 0 : " + i);
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            String rowIndexString;
            char separator;
            int index;
            clientId = super.getClientId(context);
            int rowIndex = this.getRowIndex();
            if (rowIndex != -1 && (index = clientId.lastIndexOf(separator = UINamingContainer.getSeparatorChar((FacesContext)context))) != -1 && (rowIndexString = clientId.substring(index + 1)).length() > 0 && StringUtils.isNumeric((String)rowIndexString) && rowIndex == Integer.valueOf(rowIndexString)) {
                clientId = clientId.substring(0, index - 1);
            }
        }
        return clientId;
    }

    public String getContainerClientId(FacesContext context) {
        String rowIndexString;
        int rowIndex;
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            clientId = super.getClientId(context);
        }
        if ((rowIndex = this.getRowIndex()) == -1) {
            return clientId;
        }
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        int index = clientId.lastIndexOf(separator);
        if (index != -1 && (rowIndexString = clientId.substring(index + 1)).length() > 0 && StringUtils.isNumeric((String)rowIndexString) && Integer.valueOf(rowIndexString) == rowIndex) {
            return clientId;
        }
        return clientId + separator + rowIndex;
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    protected void checkUpdateModelError(FacesContext context) {
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this._initialDescendantComponentState = null;
        if (this._isValidChilds && !this.hasErrorMessages(context)) {
            this._dataModelMap.clear();
            if (!this.isPreserveRowStates()) {
                this._rowStates.clear();
            }
        }
        super.encodeBegin(context);
    }

    public void setPreserveRowStates(boolean preserveRowStates) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.preserveRowStates), (Object)preserveRowStates);
    }

    public boolean isPreserveRowStates() {
        Object value = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.preserveRowStates), (Object)false);
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    protected boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo((Object)message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.setRowIndex(-1);
        super.encodeEnd(context);
    }

    public void setRowIndex(int rowIndex) {
        if (this.isPreserveRowComponentState() && this._initialDescendantComponentState != null) {
            this.setRowIndexPreserveComponentState(rowIndex);
        } else {
            this.setRowIndexWithoutPreserveComponentState(rowIndex);
        }
    }

    private void setRowIndexWithoutPreserveComponentState(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this._rowIndex == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._rowIndex == -1) {
            if (this._initialDescendantComponentState == null) {
                this._initialDescendantComponentState = this.saveDescendantComponentStates();
            }
        } else {
            this._rowStates.put(this.getContainerClientId(facesContext), this.saveDescendantComponentStates());
        }
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this._rowIndex == -1) {
            this.restoreDescendantComponentStates(this._initialDescendantComponentState);
        } else {
            Object rowState = this._rowStates.get(this.getContainerClientId(facesContext));
            if (rowState == null) {
                this.restoreDescendantComponentStates(this._initialDescendantComponentState);
            } else {
                this.restoreDescendantComponentStates(rowState);
            }
        }
    }

    private void setRowIndexPreserveComponentState(int rowIndex) {
        Map<String, Object> sm;
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this._rowIndex == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._initialDescendantFullComponentState != null && (sm = this.saveFullDescendantComponentStates(facesContext)) != null && !sm.isEmpty()) {
            this._rowDeltaStates.put(this.getContainerClientId(facesContext), sm);
        }
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this._initialDescendantFullComponentState != null) {
            Map<String, Object> rowState = this._rowDeltaStates.get(this.getContainerClientId(facesContext));
            if (rowState == null) {
                this.restoreFullDescendantComponentStates(facesContext, this._initialDescendantFullComponentState);
            } else {
                this.restoreFullDescendantComponentDeltaStates(facesContext, rowState, this._initialDescendantFullComponentState);
            }
        }
    }

    protected void restoreDescendantComponentStates(Object state) {
        this.restoreDescendantComponentStates(this.getChildren().iterator(), state, false);
    }

    protected void restoreDescendantComponentStates(Iterator<UIComponent> childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            if (childState != null && component instanceof EditableValueHolder) {
                ((EditableValueHolderState)childState).restoreState((EditableValueHolder)component);
            }
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreDescendantComponentStates(childsIterator, descendantState, true);
        }
    }

    protected Object saveDescendantComponentStates() {
        return this.saveDescendantComponentStates(this.getChildren().iterator(), false);
    }

    protected Object saveDescendantComponentStates(Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = childIterator.next()).isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Object descendantState = this.saveDescendantComponentStates(childsIterator, true);
            EditableValueHolderState state = null;
            if (child instanceof EditableValueHolder) {
                state = new EditableValueHolderState((EditableValueHolder)child);
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    public void markInitialState() {
        if (this.isPreserveRowComponentState() && this.getFacesContext().getAttributes().containsKey("javax.faces.view.ViewDeclarationLanguage.IS_BUILDING_INITIAL_STATE")) {
            this._initialDescendantFullComponentState = this.saveDescendantInitialComponentStates(this.getFacesContext());
        }
        super.markInitialState();
    }

    protected void restoreFullDescendantComponentStates(FacesContext facesContext, Object initialState) {
        this.restoreFullDescendantComponentStates(facesContext, this.getChildren().iterator(), initialState, false);
    }

    protected void restoreFullDescendantComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Object initialState, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && initialState != null) {
                descendantStateIterator = ((Collection)initialState).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            String childId = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                do {
                    Object[] object = (Object[])descendantStateIterator.next();
                    childState = object[0];
                    descendantState = object[1];
                    childId = (String)object[2];
                } while (descendantStateIterator.hasNext() && !component.getId().equals(childId));
                if (!component.getId().equals(childId)) {
                    throw new IllegalStateException("Cannot restore row correctly.");
                }
            }
            component.clearInitialState();
            component.restoreState(facesContext, childState);
            component.markInitialState();
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreFullDescendantComponentStates(facesContext, childsIterator, descendantState, true);
        }
    }

    protected Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext) {
        return this.saveDescendantInitialComponentStates(facesContext, this.getChildren().iterator(), false);
    }

    protected Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = childIterator.next()).isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Collection<Object[]> descendantState = this.saveDescendantInitialComponentStates(facesContext, childsIterator, true);
            Object state = null;
            if (child.initialStateMarked()) {
                child.clearInitialState();
                state = child.saveState(facesContext);
                child.markInitialState();
            } else {
                state = child.saveState(facesContext);
            }
            childStates.add(new Object[]{state, descendantState, child.getId()});
        }
        return childStates;
    }

    protected Map<String, Object> saveFullDescendantComponentStates(FacesContext facesContext) {
        return this.saveFullDescendantComponentStates(facesContext, null, this.getChildren().iterator(), false, this.getContainerClientId(facesContext));
    }

    protected Map<String, Object> saveFullDescendantComponentStates(FacesContext facesContext, Map<String, Object> stateMap, Iterator<UIComponent> childIterator, boolean saveChildFacets, String containerClientId) {
        while (childIterator.hasNext()) {
            UIComponent child = childIterator.next();
            if (child.isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            stateMap = this.saveFullDescendantComponentStates(facesContext, stateMap, childsIterator, true, containerClientId);
            Object state = child.saveState(facesContext);
            if (state == null) continue;
            if (stateMap == null) {
                stateMap = new HashMap<String, Object>();
            }
            stateMap.put(child.getClientId(facesContext).substring(containerClientId.length() + 1), state);
        }
        return stateMap;
    }

    protected void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Map<String, Object> rowState, Object initialState) {
        this.restoreFullDescendantComponentDeltaStates(facesContext, this.getChildren().iterator(), rowState, initialState, false, this.getContainerClientId(facesContext));
    }

    protected void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Map<String, Object> state, Object initialState, boolean restoreChildFacets, String containerClientId) {
        Iterator descendantFullStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantFullStateIterator == null && initialState != null) {
                descendantFullStateIterator = ((Collection)initialState).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childInitialState = null;
            Object descendantInitialState = null;
            Object childState = null;
            String childId = null;
            Object object = childState = state == null ? null : state.get(component.getClientId(facesContext).substring(containerClientId.length() + 1));
            if (descendantFullStateIterator != null && descendantFullStateIterator.hasNext()) {
                do {
                    Object[] object2 = (Object[])descendantFullStateIterator.next();
                    childInitialState = object2[0];
                    descendantInitialState = object2[1];
                    childId = (String)object2[2];
                } while (descendantFullStateIterator.hasNext() && !component.getId().equals(childId));
                if (!component.getId().equals(childId)) {
                    throw new IllegalStateException("Cannot restore row correctly.");
                }
            }
            component.clearInitialState();
            if (childInitialState != null) {
                component.restoreState(facesContext, childInitialState);
                component.markInitialState();
                component.restoreState(facesContext, childState);
            } else {
                component.restoreState(facesContext, childState);
                component.markInitialState();
            }
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreFullDescendantComponentDeltaStates(facesContext, childsIterator, state, descendantInitialState, true, containerClientId);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredRowStates = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[1]);
        if (restoredRowStates == null) {
            if (!this._rowDeltaStates.isEmpty()) {
                this._rowDeltaStates.clear();
            }
        } else {
            this._rowDeltaStates = (Map)restoredRowStates;
        }
    }

    public Object saveState(FacesContext context) {
        if (this.initialStateMarked()) {
            Object parentSaved = super.saveState(context);
            if (parentSaved == null && this._rowDeltaStates.isEmpty()) {
                return null;
            }
            Object[] values = new Object[]{parentSaved, UIComponentBase.saveAttachedState((FacesContext)context, this._rowDeltaStates)};
            return values;
        }
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState((FacesContext)context, this._rowDeltaStates)};
        return values;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("You can never set the 'rowIndex' or the 'var' attribute as a value-binding. Set the property directly instead. Name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("You can never set the 'rowIndex' or the 'var' attribute as a value-binding. Set the property directly instead. Name " + name);
        }
        super.setValueExpression(name, binding);
    }

    public void setValue(Object value) {
        super.setValue(value);
        this._dataModelMap.clear();
        this._rowStates.clear();
        this._rowDeltaStates.clear();
        this._isValidChilds = true;
    }

    protected DataModel getDataModel() {
        DataModel dataModel = null;
        String clientID = "";
        UIComponent parent = this.getParent();
        if (parent != null) {
            clientID = parent.getContainerClientId(this.getFacesContext());
        }
        if ((dataModel = this._dataModelMap.get(clientID)) == null) {
            dataModel = this.createDataModel();
            this._dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    protected void setDataModel(DataModel datamodel) {
        UIComponent parent = this.getParent();
        String clientID = "";
        if (parent != null) {
            clientID = parent.getContainerClientId(this.getFacesContext());
        }
        this._dataModelMap.put(clientID, datamodel);
    }

    protected DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (value instanceof Collection) {
            return new ListDataModel(new ArrayList((Collection)value));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    @Override
    public boolean isForceId() {
        Object value = this.getStateHelper().get((Serializable)((Object)PropertyKeys.forceId));
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    @Override
    public void setForceId(boolean forceId) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forceId), (Object)forceId);
    }

    public boolean isForceIdIndex() {
        Object value = this.getStateHelper().get((Serializable)((Object)PropertyKeys.forceIdIndex));
        if (value != null) {
            return (Boolean)value;
        }
        return true;
    }

    public void setForceIdIndex(boolean forceIdIndex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.forceIdIndex), (Object)forceIdIndex);
    }

    public void clearRowStates() {
        if (this.isPreserveRowComponentState()) {
            this._rowDeltaStates.clear();
        } else {
            this._rowStates.clear();
        }
    }

    public void deleteRowStateForRow(int deletedIndex) {
        int savedRowIndex = this.getRowIndex();
        FacesContext facesContext = this.getFacesContext();
        this.setRowIndex(deletedIndex);
        String currentRowStateKey = this.getContainerClientId(facesContext);
        int rowCount = this.getRowCount();
        if (this.isPreserveRowComponentState()) {
            for (int index = deletedIndex + 1; index < rowCount; ++index) {
                this.setRowIndex(index);
                String nextRowStateKey = this.getContainerClientId(facesContext);
                Map<String, Object> nextRowState = this._rowDeltaStates.get(nextRowStateKey);
                if (nextRowState == null) {
                    this._rowDeltaStates.remove(currentRowStateKey);
                } else {
                    this._rowDeltaStates.put(currentRowStateKey, nextRowState);
                }
                currentRowStateKey = nextRowStateKey;
            }
            this.setRowIndex(savedRowIndex);
            this._rowDeltaStates.remove(currentRowStateKey);
        } else {
            for (int index = deletedIndex + 1; index < rowCount; ++index) {
                this.setRowIndex(index);
                String nextRowStateKey = this.getContainerClientId(facesContext);
                Object nextRowState = this._rowStates.get(nextRowStateKey);
                if (nextRowState == null) {
                    this._rowStates.remove(currentRowStateKey);
                } else {
                    this._rowStates.put(currentRowStateKey, nextRowState);
                }
                currentRowStateKey = nextRowStateKey;
            }
            this.setRowIndex(savedRowIndex);
            this._rowStates.remove(currentRowStateKey);
        }
    }

    public boolean isPreserveRowComponentState() {
        Boolean b = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.preserveRowComponentState));
        return b == null ? false : b;
    }

    public void setPreserveRowComponentState(boolean preserveComponentState) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.preserveRowComponentState), (Object)preserveComponentState);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        preserveRowStates,
        forceId,
        forceIdIndex,
        preserveRowComponentState;

    }

    private class EditableValueHolderState {
        private final Object _value;
        private final boolean _localValueSet;
        private final boolean _valid;
        private final Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._localValueSet = evh.isLocalValueSet();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setLocalValueSet(this._localValueSet);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
        }
    }
}

