/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navigation;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.AlignProperty;
import org.apache.myfaces.component.DataProperties;
import org.apache.myfaces.component.EventAware;
import org.apache.myfaces.component.PanelProperties;
import org.apache.myfaces.component.UniversalProperties;
import org.apache.myfaces.custom.navigation.HtmlCommandNavigation;

public abstract class AbstractHtmlPanelNavigation
extends HtmlPanelGroup
implements AlignProperty,
UniversalProperties,
EventAware,
DataProperties,
PanelProperties,
ClientBehaviorHolder {
    private static final Log log = LogFactory.getLog(AbstractHtmlPanelNavigation.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlPanelNavigation";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Navigation";
    private static final int DEFAULT_BORDER = Integer.MIN_VALUE;
    private static final String PREVIOUS_VIEW_ROOT = AbstractHtmlPanelNavigation.class.getName() + ".PREVIOUS_VIEW_ROOT";
    private boolean _itemOpenActiveStatesRestored = false;

    public void decode(FacesContext context) {
        super.decode(context);
        context.getExternalContext().getRequestMap().put(PREVIOUS_VIEW_ROOT, context.getViewRoot());
        this._itemOpenActiveStatesRestored = true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIViewRoot previousRoot;
        if (!this._itemOpenActiveStatesRestored && this.getChildCount() > 0 && (previousRoot = (UIViewRoot)context.getExternalContext().getRequestMap().get(PREVIOUS_VIEW_ROOT)) != null) {
            this.restoreOpenActiveStates(context, previousRoot, this.getChildren());
        }
        super.encodeBegin(context);
    }

    public void restoreOpenActiveStates(FacesContext facesContext, UIViewRoot previousRoot, List children) {
        for (UIComponent child : children) {
            if (!(child instanceof HtmlCommandNavigation)) continue;
            HtmlCommandNavigation previousItem = (HtmlCommandNavigation)previousRoot.findComponent(child.getClientId(facesContext));
            if (previousItem != null) {
                HtmlCommandNavigation childItem = (HtmlCommandNavigation)child;
                if (previousItem.getOpenDirectly() != null) {
                    childItem.setOpen(previousItem.isOpen());
                } else if (previousItem.getValueExpression("open") != null) {
                    childItem.setValueExpression("open", previousItem.getValueExpression("open"));
                }
                if (previousItem.getActiveDirectly() != null) {
                    childItem.setActive(previousItem.isActive());
                } else if (previousItem.getValueExpression("active") != null) {
                    childItem.setValueExpression("active", previousItem.getValueExpression("active"));
                }
            } else {
                log.error((Object)("Navigation item " + child.getClientId(facesContext) + " not found in previous view."));
            }
            if (child.getChildCount() <= 0) continue;
            this.restoreOpenActiveStates(facesContext, previousRoot, child.getChildren());
        }
    }

    public abstract String getItemClass();

    public abstract String getOpenItemClass();

    public abstract String getActiveItemClass();

    public abstract String getSeparatorClass();

    public abstract String getItemStyle();

    public abstract String getOpenItemStyle();

    public abstract String getActiveItemStyle();

    public abstract String getSeparatorStyle();
}

