/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.render.Renderer;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.ScheduleCompactMonthRenderer;
import org.apache.myfaces.custom.schedule.ScheduleCompactWeekRenderer;
import org.apache.myfaces.custom.schedule.ScheduleDetailedDayRenderer;
import org.apache.myfaces.tomahawk.application.PreRenderViewAddResourceEvent;

@ResourceDependency(library="oam.custom.schedule.javascript", name="schedule.js")
@ListenerFor(systemEventClass=PreRenderViewAddResourceEvent.class)
public class ScheduleDelegatingRenderer
extends Renderer
implements Serializable,
ComponentSystemEventListener {
    private static final long serialVersionUID = -837566590780480244L;
    private final ScheduleCompactMonthRenderer monthDelegate = new ScheduleCompactMonthRenderer();
    private final ScheduleCompactWeekRenderer weekDelegate = new ScheduleCompactWeekRenderer();
    private final ScheduleDetailedDayRenderer dayDelegate = new ScheduleDetailedDayRenderer();

    public void processEvent(ComponentSystemEvent event) {
        Renderer renderer = this.getDelegateRenderer(event.getComponent());
        if (renderer instanceof ComponentSystemEventListener) {
            ((ComponentSystemEventListener)renderer).processEvent(event);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        this.getDelegateRenderer(component).decode(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.getDelegateRenderer(component).encodeBegin(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.getDelegateRenderer(component).encodeChildren(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.getDelegateRenderer(component).encodeEnd(context, component);
    }

    protected Renderer getDelegateRenderer(UIComponent component) {
        HtmlSchedule schedule = (HtmlSchedule)component;
        if (schedule == null || schedule.getModel() == null) {
            return this.dayDelegate;
        }
        switch (schedule.getModel().getMode()) {
            case 2: {
                return this.weekDelegate;
            }
            case 3: {
                return this.monthDelegate;
            }
        }
        return this.dayDelegate;
    }

    public boolean getRendersChildren() {
        return true;
    }
}

