/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.swapimage;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.navigation.HtmlCommandNavigation;
import org.apache.myfaces.custom.swapimage.HtmlSwapImage;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

@ResourceDependency(library="oam.custom.swapimage", name="swapimage.js")
public class HtmlSwapImageRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlSwapImageRenderer.class);

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String url;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlSwapImage swapImage = (HtmlSwapImage)uiComponent;
        Map behaviors = swapImage.getClientBehaviors();
        if (!behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if ((url = uiComponent.getParent() instanceof HtmlCommandNavigation ? (((HtmlCommandNavigation)uiComponent.getParent()).isActive() ? ((HtmlSwapImage)uiComponent).getActiveImageUrl() : ((HtmlSwapImage)uiComponent).getUrl()) : ((HtmlSwapImage)uiComponent).getUrl()) != null && url.length() > 0) {
            writer.startElement("img", uiComponent);
            this.renderId(facesContext, uiComponent);
            String src = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
            writer.writeURIAttribute("src", (Object)facesContext.getExternalContext().encodeResourceURL(src), null);
            String swapImageUrl = ((HtmlSwapImage)uiComponent).getSwapImageUrl();
            swapImageUrl = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, swapImageUrl);
            if (behaviors != null && !behaviors.isEmpty()) {
                if (swapImageUrl != null) {
                    HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, "mouseover", null, behaviors, "onmouseover", swapImage.getOnmouseover(), "org.apache.myfaces.SwapImage.swapImage('" + this.getClientId(facesContext, uiComponent) + "','','" + facesContext.getExternalContext().encodeResourceURL(swapImageUrl) + "',1);");
                    HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, "mouseout", null, behaviors, "onmouseout", swapImage.getOnmouseout(), "org.apache.myfaces.SwapImage.restore();");
                } else {
                    HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, "mouseover", null, behaviors, "onmouseover", swapImage.getOnmouseover(), null);
                    HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, "mouseout", null, behaviors, "onmouseout", swapImage.getOnmouseout(), null);
                }
                HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnmouseoverAndOnmouseout(facesContext, writer, uiComponent, behaviors);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.UNIVERSAL_ATTRIBUTES);
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
            } else {
                if (swapImageUrl != null) {
                    writer.writeAttribute("onmouseover", (Object)("org.apache.myfaces.SwapImage.swapImage('" + this.getClientId(facesContext, uiComponent) + "','','" + facesContext.getExternalContext().encodeResourceURL(swapImageUrl) + "',1);"), null);
                    writer.writeAttribute("onmouseout", (Object)"org.apache.myfaces.SwapImage.restore();", null);
                } else {
                    HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "onmouseover", "onmouseover");
                    HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "onmouseout", "onmouseout");
                }
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONMOUSEOVER_AND_ONMOUSEOUT);
            }
            writer.endElement("img");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Graphic with id " + uiComponent.getClientId(facesContext) + " has no value (url)."));
        }
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }
}

