/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.processor.FlowFileFilter;

public interface FlowFileQueue {
    public String getIdentifier();

    public List<FlowFilePrioritizer> getPriorities();

    public SwapSummary recoverSwappedFlowFiles();

    public void purgeSwapFiles();

    public int getSwapFileCount();

    public void setPriorities(List<FlowFilePrioritizer> var1);

    public void setBackPressureObjectThreshold(long var1);

    public long getBackPressureObjectThreshold();

    public void setBackPressureDataSizeThreshold(String var1);

    public String getBackPressureDataSizeThreshold();

    public QueueSize size();

    public boolean isEmpty();

    public boolean isActiveQueueEmpty();

    public QueueSize getUnacknowledgedQueueSize();

    public QueueSize getActiveQueueSize();

    public QueueSize getSwapQueueSize();

    public void acknowledge(FlowFileRecord var1);

    public void acknowledge(Collection<FlowFileRecord> var1);

    public boolean isFull();

    public boolean isAnyActiveFlowFilePenalized();

    public boolean isAllActiveFlowFilesPenalized();

    public void put(FlowFileRecord var1);

    public void putAll(Collection<FlowFileRecord> var1);

    public FlowFileRecord poll(Set<FlowFileRecord> var1);

    public List<FlowFileRecord> poll(int var1, Set<FlowFileRecord> var2);

    public long drainQueue(Queue<FlowFileRecord> var1, List<FlowFileRecord> var2, int var3, Set<FlowFileRecord> var4);

    public List<FlowFileRecord> poll(FlowFileFilter var1, Set<FlowFileRecord> var2);

    public String getFlowFileExpiration();

    public int getFlowFileExpiration(TimeUnit var1);

    public void setFlowFileExpiration(String var1);

    public DropFlowFileStatus dropFlowFiles(String var1, String var2);

    public DropFlowFileStatus getDropFlowFileStatus(String var1);

    public DropFlowFileStatus cancelDropFlowFileRequest(String var1);

    public ListFlowFileStatus listFlowFiles(String var1, int var2);

    public ListFlowFileStatus getListFlowFileStatus(String var1);

    public ListFlowFileStatus cancelListFlowFileRequest(String var1);

    public FlowFileRecord getFlowFile(String var1) throws IOException;

    public void verifyCanList() throws IllegalStateException;
}

