/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockControllerServiceLookup;

public class MockControllerServiceInitializationContext
extends MockControllerServiceLookup
implements ControllerServiceInitializationContext,
ControllerServiceLookup {
    private final String identifier;
    private final ComponentLog logger;
    private final StateManager stateManager;

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier) {
        this(controllerService, identifier, new MockStateManager(controllerService));
    }

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier, StateManager stateManager) {
        this(controllerService, identifier, new MockComponentLog(identifier, controllerService), stateManager);
    }

    public MockControllerServiceInitializationContext(ControllerService controllerService, String identifier, ComponentLog logger, StateManager stateManager) {
        this.identifier = identifier;
        this.logger = logger;
        this.stateManager = stateManager;
        this.addControllerService(controllerService, identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getControllerServiceName(String serviceIdentifier) {
        return null;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getKerberosServicePrincipal() {
        return null;
    }

    public File getKerberosServiceKeytab() {
        return null;
    }

    public File getKerberosConfigurationFile() {
        return null;
    }
}

