/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockPropertyValue;

public class MockValidationContext
extends MockControllerServiceLookup
implements ValidationContext,
ControllerServiceLookup {
    private final MockProcessContext context;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;

    public MockValidationContext(MockProcessContext processContext) {
        this(processContext, null, VariableRegistry.EMPTY_REGISTRY);
    }

    public MockValidationContext(MockProcessContext processContext, StateManager stateManager, VariableRegistry variableRegistry) {
        this.context = processContext;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        Map<PropertyDescriptor, String> properties = processContext.getProperties();
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
    }

    @Override
    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new MockPropertyValue(rawValue, this, this.variableRegistry);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(this.variableRegistry);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        MockProcessContext serviceProcessContext = new MockProcessContext(controllerService, this.context, this.stateManager, this.variableRegistry);
        return new MockValidationContext(serviceProcessContext, this.stateManager, this.variableRegistry);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        return this.context.getProperty(property);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.context.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        return this.context.getAnnotationData();
    }

    @Override
    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.context.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    @Override
    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.context.isControllerServiceEnabled(serviceIdentifier);
    }

    @Override
    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.context.isControllerServiceEnabled(service);
    }

    @Override
    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(serviceIdentifier);
        return configuration == null ? null : serviceIdentifier;
    }

    public boolean isValidationRequired(ControllerService service) {
        return true;
    }

    @Override
    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.context.isControllerServiceEnabling(serviceIdentifier);
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return "unit test";
    }
}

