/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public class NarDependencyUtils {
    public static final String NAR = "nar";
    public static final String COMPILE_STRING = "compile";

    public static Map<String, ArtifactHandler> createNarHandlerMap(ProjectBuildingRequest narRequest, MavenProject project, ProjectBuilder projectBuilder) throws ProjectBuildingException {
        Artifact projectArtifact = project.getArtifact();
        ProjectBuildingResult narResult = projectBuilder.build(projectArtifact, narRequest);
        narRequest.setProject(narResult.getProject());
        ArtifactHandler narHandler = NarDependencyUtils.excludesDependencies(projectArtifact);
        projectArtifact.setArtifactHandler(narHandler);
        HashMap<String, ArtifactHandler> narHandlerMap = new HashMap<String, ArtifactHandler>();
        narHandlerMap.put(NAR, narHandler);
        return narHandlerMap;
    }

    public static void ensureSingleNarDependencyExists(MavenProject project) throws MojoExecutionException {
        boolean found = false;
        for (Artifact artifact : project.getDependencyArtifacts()) {
            if (!NAR.equals(artifact.getType())) continue;
            if (found) {
                throw new MojoExecutionException("Project can only have one NAR dependency.");
            }
            found = true;
        }
        if (!found) {
            throw new MojoExecutionException("Project does not have any NAR dependencies.");
        }
    }

    private static ArtifactHandler excludesDependencies(Artifact artifact) {
        final ArtifactHandler orig = artifact.getArtifactHandler();
        return new ArtifactHandler(){

            public String getExtension() {
                return orig.getExtension();
            }

            public String getDirectory() {
                return orig.getDirectory();
            }

            public String getClassifier() {
                return orig.getClassifier();
            }

            public String getPackaging() {
                return orig.getPackaging();
            }

            public boolean isIncludesDependencies() {
                return false;
            }

            public String getLanguage() {
                return orig.getLanguage();
            }

            public boolean isAddedToClasspath() {
                return orig.isAddedToClasspath();
            }
        };
    }
}

