/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.AESSensitivePropertyProviderFactory;
import org.apache.nifi.properties.ProtectedNiFiProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.util.NiFiProperties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(NiFiPropertiesLoader.class);
    private static final String RELATIVE_PATH = "conf/nifi.properties";
    private static final String BOOTSTRAP_KEY_PREFIX = "nifi.bootstrap.sensitive.key=";
    private NiFiProperties instance;
    private String keyHex;
    private static SensitivePropertyProviderFactory sensitivePropertyProviderFactory;

    public static NiFiPropertiesLoader withKey(String keyHex) {
        NiFiPropertiesLoader loader = new NiFiPropertiesLoader();
        loader.setKeyHex(keyHex);
        return loader;
    }

    public void setKeyHex(String keyHex) {
        if (this.keyHex != null && !this.keyHex.trim().isEmpty()) {
            throw new RuntimeException("Cannot overwrite an existing key");
        }
        this.keyHex = keyHex;
    }

    public static NiFiProperties loadDefaultWithKeyFromBootstrap() throws IOException {
        try {
            String keyHex = NiFiPropertiesLoader.extractKeyFromBootstrapFile();
            return NiFiPropertiesLoader.withKey(keyHex).loadDefault();
        }
        catch (IOException e) {
            logger.error("Encountered an exception loading the default nifi.properties file {} with the key provided in bootstrap.conf", (Object)NiFiPropertiesLoader.getDefaultFilePath(), (Object)e);
            throw e;
        }
    }

    public static String extractKeyFromBootstrapFile() throws IOException {
        return NiFiPropertiesLoader.extractKeyFromBootstrapFile("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractKeyFromBootstrapFile(String bootstrapPath) throws IOException {
        File expectedBootstrapFile;
        block22: {
            if (StringUtils.isBlank((CharSequence)bootstrapPath)) {
                String defaultNiFiPropertiesPath = NiFiPropertiesLoader.getDefaultFilePath();
                File propertiesFile = new File(defaultNiFiPropertiesPath);
                File confDir = new File(propertiesFile.getParent());
                if (confDir.exists() && confDir.canRead()) {
                    expectedBootstrapFile = new File(confDir, "bootstrap.conf");
                    break block22;
                } else {
                    logger.error("Cannot read from bootstrap.conf file at {} to extract encryption key -- conf/ directory is missing or permissions are incorrect", (Object)confDir.getAbsolutePath());
                    throw new IOException("Cannot read from bootstrap.conf");
                }
            }
            expectedBootstrapFile = new File(bootstrapPath);
        }
        if (expectedBootstrapFile.exists() && expectedBootstrapFile.canRead()) {
            try (Stream<String> stream = Files.lines(Paths.get(expectedBootstrapFile.getAbsolutePath(), new String[0]));){
                Optional<String> keyLine = stream.filter(l -> l.startsWith(BOOTSTRAP_KEY_PREFIX)).findFirst();
                if (keyLine.isPresent()) {
                    String string = keyLine.get().split("=", 2)[1];
                    return string;
                }
                logger.warn("No encryption key present in the bootstrap.conf file at {}", (Object)expectedBootstrapFile.getAbsolutePath());
                String string = "";
                return string;
            }
            catch (IOException e) {
                logger.error("Cannot read from bootstrap.conf file at {} to extract encryption key", (Object)expectedBootstrapFile.getAbsolutePath());
                throw new IOException("Cannot read from bootstrap.conf", e);
            }
        }
        logger.error("Cannot read from bootstrap.conf file at {} to extract encryption key -- file is missing or permissions are incorrect", (Object)expectedBootstrapFile.getAbsolutePath());
        throw new IOException("Cannot read from bootstrap.conf");
    }

    private static String getDefaultFilePath() {
        String systemPath = System.getProperty("nifi.properties.file.path");
        if (systemPath == null || systemPath.trim().isEmpty()) {
            logger.warn("The system variable {} is not set, so it is being set to '{}'", (Object)"nifi.properties.file.path", (Object)RELATIVE_PATH);
            System.setProperty("nifi.properties.file.path", RELATIVE_PATH);
            systemPath = RELATIVE_PATH;
        }
        logger.info("Determined default nifi.properties path to be '{}'", (Object)systemPath);
        return systemPath;
    }

    private NiFiProperties loadDefault() {
        return this.load(NiFiPropertiesLoader.getDefaultFilePath());
    }

    private static String getDefaultProviderKey() {
        try {
            return "aes/gcm/" + (Cipher.getMaxAllowedKeyLength("AES") > 128 ? "256" : "128");
        }
        catch (NoSuchAlgorithmException e) {
            return "aes/gcm/128";
        }
    }

    private void initializeSensitivePropertyProviderFactory() {
        sensitivePropertyProviderFactory = new AESSensitivePropertyProviderFactory(this.keyHex);
    }

    private SensitivePropertyProvider getSensitivePropertyProvider() {
        this.initializeSensitivePropertyProviderFactory();
        return sensitivePropertyProviderFactory.getProvider();
    }

    ProtectedNiFiProperties readProtectedPropertiesFromDisk(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            String path = file == null ? "missing file" : file.getAbsolutePath();
            logger.error("Cannot read from '{}' -- file is missing or not readable", (Object)path);
            throw new IllegalArgumentException("NiFi properties file missing or unreadable");
        }
        Properties rawProperties = new Properties();
        BufferedInputStream inStream = null;
        try {
            ProtectedNiFiProperties protectedNiFiProperties;
            inStream = new BufferedInputStream(new FileInputStream(file));
            rawProperties.load(inStream);
            logger.info("Loaded {} properties from {}", (Object)rawProperties.size(), (Object)file.getAbsolutePath());
            ProtectedNiFiProperties protectedNiFiProperties2 = protectedNiFiProperties = new ProtectedNiFiProperties(rawProperties);
            return protectedNiFiProperties2;
        }
        catch (Exception ex) {
            logger.error("Cannot load properties file due to " + ex.getLocalizedMessage());
            throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
        }
        finally {
            if (null != inStream) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public NiFiProperties load(File file) {
        ProtectedNiFiProperties protectedNiFiProperties = this.readProtectedPropertiesFromDisk(file);
        if (protectedNiFiProperties.hasProtectedKeys()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            protectedNiFiProperties.addSensitivePropertyProvider(this.getSensitivePropertyProvider());
        }
        return protectedNiFiProperties.getUnprotectedProperties();
    }

    public NiFiProperties load(String path) {
        if (path != null && !path.trim().isEmpty()) {
            return this.load(new File(path));
        }
        return this.loadDefault();
    }

    public NiFiProperties get() {
        if (this.instance == null) {
            this.instance = this.loadDefault();
        }
        return this.instance;
    }
}

