/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.security.KeyManagementException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.apache.nifi.security.kms.CryptoUtils;
import org.apache.nifi.security.kms.FileBasedKeyProvider;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.StaticKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyProviderFactory.class);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static KeyProvider buildKeyProvider(String implementationClassName, String keyProviderLocation, String keyId, Map<String, String> encryptionKeys, SecretKey masterKey) throws KeyManagementException {
        void var5_9;
        implementationClassName = CryptoUtils.handleLegacyPackages(implementationClassName);
        if (!StaticKeyProvider.class.getName().equals(implementationClassName)) {
            if (!FileBasedKeyProvider.class.getName().equals(implementationClassName)) throw new KeyManagementException("Invalid key provider implementation provided: " + implementationClassName);
            FileBasedKeyProvider fileBasedKeyProvider = new FileBasedKeyProvider(keyProviderLocation, masterKey);
            if (fileBasedKeyProvider.keyExists(keyId)) return var5_9;
            throw new KeyManagementException("The specified key ID " + keyId + " is not in the key definition file");
        }
        if (CryptoUtils.isValidKeyProvider(implementationClassName, keyProviderLocation, keyId, encryptionKeys)) {
            Map<String, SecretKey> formedKeys = encryptionKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                try {
                    return CryptoUtils.formKeyFromHex((String)e.getValue());
                }
                catch (KeyManagementException e1) {
                    logger.error("Encountered an error: ", (Throwable)e1);
                    return null;
                }
            }));
            StaticKeyProvider staticKeyProvider = new StaticKeyProvider(formedKeys);
            return var5_9;
        }
        String msg = "The StaticKeyProvider definition is not valid";
        logger.error("The StaticKeyProvider definition is not valid");
        throw new KeyManagementException("The StaticKeyProvider definition is not valid");
    }

    public static boolean requiresMasterKey(String implementationClassName) throws KeyManagementException {
        implementationClassName = CryptoUtils.handleLegacyPackages(implementationClassName);
        return FileBasedKeyProvider.class.getName().equals(implementationClassName);
    }
}

