/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtils {
    private static final String UNION = "|";
    private static final double BYTES_IN_KILOBYTE = 1024.0;
    private static final double BYTES_IN_MEGABYTE = 1048576.0;
    private static final double BYTES_IN_GIGABYTE = 1.073741824E9;
    private static final double BYTES_IN_TERABYTE = 1.099511627776E12;
    private static final String NANOS = FormatUtils.join("|", "ns", "nano", "nanos", "nanosecond", "nanoseconds");
    private static final String MILLIS = FormatUtils.join("|", "ms", "milli", "millis", "millisecond", "milliseconds");
    private static final String SECS = FormatUtils.join("|", "s", "sec", "secs", "second", "seconds");
    private static final String MINS = FormatUtils.join("|", "m", "min", "mins", "minute", "minutes");
    private static final String HOURS = FormatUtils.join("|", "h", "hr", "hrs", "hour", "hours");
    private static final String DAYS = FormatUtils.join("|", "d", "day", "days");
    private static final String WEEKS = FormatUtils.join("|", "w", "wk", "wks", "week", "weeks");
    private static final String VALID_TIME_UNITS = FormatUtils.join("|", NANOS, MILLIS, SECS, MINS, HOURS, DAYS, WEEKS);
    public static final String TIME_DURATION_REGEX = "(\\d+)\\s*(" + VALID_TIME_UNITS + ")";
    public static final Pattern TIME_DURATION_PATTERN = Pattern.compile(TIME_DURATION_REGEX);

    public static String formatCount(long count) {
        return NumberFormat.getIntegerInstance().format(count);
    }

    public static String formatMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInMinute = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
        int minutes = (int)(millis / millisInMinute);
        long secondsMillisLeft = millis - (long)minutes * millisInMinute;
        long millisInSecond = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
        int seconds = (int)(secondsMillisLeft / millisInSecond);
        long millisLeft = secondsMillisLeft - (long)seconds * millisInSecond;
        return FormatUtils.pad2Places(minutes) + ":" + FormatUtils.pad2Places(seconds) + "." + FormatUtils.pad3Places(millisLeft);
    }

    public static String formatHoursMinutesSeconds(long sourceDuration, TimeUnit sourceUnit) {
        long millis = TimeUnit.MILLISECONDS.convert(sourceDuration, sourceUnit);
        long millisInHour = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
        int hours = (int)(millis / millisInHour);
        long minutesSecondsMillisLeft = millis - (long)hours * millisInHour;
        return FormatUtils.pad2Places(hours) + ":" + FormatUtils.formatMinutesSeconds(minutesSecondsMillisLeft, TimeUnit.MILLISECONDS);
    }

    private static String pad2Places(long val) {
        return val < 10L ? "0" + val : String.valueOf(val);
    }

    private static String pad3Places(long val) {
        return val < 100L ? "0" + FormatUtils.pad2Places(val) : String.valueOf(val);
    }

    public static String formatDataSize(double dataSize) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        double dataSizeToFormat = dataSize / 1.099511627776E12;
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " TB";
        }
        dataSizeToFormat = dataSize / 1.073741824E9;
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " GB";
        }
        dataSizeToFormat = dataSize / 1048576.0;
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " MB";
        }
        dataSizeToFormat = dataSize / 1024.0;
        if (dataSizeToFormat > 1.0) {
            return format.format(dataSizeToFormat) + " KB";
        }
        return format.format(dataSize) + " bytes";
    }

    public static long getTimeDuration(String value, TimeUnit desiredUnit) {
        Matcher matcher = TIME_DURATION_PATTERN.matcher(value.toLowerCase());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Value '" + value + "' is not a valid Time Duration");
        }
        String duration = matcher.group(1);
        String units = matcher.group(2);
        TimeUnit specifiedTimeUnit = null;
        switch (units.toLowerCase()) {
            case "ns": 
            case "nano": 
            case "nanos": 
            case "nanoseconds": {
                specifiedTimeUnit = TimeUnit.NANOSECONDS;
                break;
            }
            case "ms": 
            case "milli": 
            case "millis": 
            case "milliseconds": {
                specifiedTimeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case "s": 
            case "sec": 
            case "secs": 
            case "second": 
            case "seconds": {
                specifiedTimeUnit = TimeUnit.SECONDS;
                break;
            }
            case "m": 
            case "min": 
            case "mins": 
            case "minute": 
            case "minutes": {
                specifiedTimeUnit = TimeUnit.MINUTES;
                break;
            }
            case "h": 
            case "hr": 
            case "hrs": 
            case "hour": 
            case "hours": {
                specifiedTimeUnit = TimeUnit.HOURS;
                break;
            }
            case "d": 
            case "day": 
            case "days": {
                specifiedTimeUnit = TimeUnit.DAYS;
                break;
            }
            case "w": 
            case "wk": 
            case "wks": 
            case "week": 
            case "weeks": {
                long durationVal = Long.parseLong(duration);
                return desiredUnit.convert(durationVal, TimeUnit.DAYS) * 7L;
            }
        }
        long durationVal = Long.parseLong(duration);
        return desiredUnit.convert(durationVal, specifiedTimeUnit);
    }

    public static String formatUtilization(double utilization) {
        return utilization + "%";
    }

    private static String join(String delimiter, String ... values) {
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.append(delimiter).append(values[i]);
        }
        return sb.toString();
    }

    public static String formatNanos(long nanos, boolean includeTotalNanos) {
        StringBuilder sb = new StringBuilder();
        long seconds = nanos > 1000000000L ? nanos / 1000000000L : 0L;
        long millis = nanos > 1000000L ? nanos / 1000000L : 0L;
        long nanosLeft = nanos % 1000000L;
        if (seconds > 0L) {
            sb.append(seconds).append(" seconds");
        }
        if (millis > 0L) {
            if (seconds > 0L) {
                sb.append(", ");
                millis -= seconds * 1000L;
            }
            sb.append(millis).append(" millis");
        }
        if (seconds > 0L || millis > 0L) {
            sb.append(", ");
        }
        sb.append(nanosLeft).append(" nanos");
        if (includeTotalNanos) {
            sb.append(" (").append(nanos).append(" nanos)");
        }
        return sb.toString();
    }
}

