/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.ext.dynamicreg.client.response;

import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.apache.oltu.oauth2.ext.dynamicreg.client.validators.RegistrationValidator;
import org.codehaus.jettison.json.JSONException;

public class OAuthClientRegistrationResponse
extends OAuthClientResponse {
    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        this.validator = new RegistrationValidator();
        super.init(body, contentType, responseCode);
    }

    protected void setBody(String body) throws OAuthProblemException {
        try {
            this.body = body;
            this.parameters = JSONUtils.parseJSON((String)body);
        }
        catch (JSONException e) {
            throw OAuthProblemException.error((String)"unsupported_response_type", (String)"Invalid response! Response body is not application/json encoded");
        }
    }

    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getClientId() {
        return this.getParam("client_id");
    }

    public String getClientSecret() {
        return this.getParam("client_secret");
    }

    public String getIssuedAt() {
        return this.getParam("issued_at");
    }

    public Long getExpiresIn() {
        String value = this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }
}

