/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openaz.pepapi.Obligation;
import org.apache.openaz.pepapi.std.ObligationCriterion;

public final class ObligationAttributeCriterion
implements ObligationCriterion {
    private String id;
    private Set<String> valueSet;

    public ObligationAttributeCriterion(String id) {
        this.id = id;
        this.valueSet = new HashSet<String>();
    }

    ObligationAttributeCriterion(String id, String ... values) {
        this(id);
        if (values != null && values.length > 0) {
            this.valueSet.addAll(Arrays.asList(values));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.valueSet == null ? 0 : this.valueSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObligationAttributeCriterion other = (ObligationAttributeCriterion)obj;
        if (this.id == null && other.id != null) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.valueSet == null && other.valueSet != null) {
            return false;
        }
        return this.valueSet.equals(other.valueSet);
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getValueSet() {
        return Collections.unmodifiableSet(this.valueSet);
    }

    @Override
    public boolean match(Obligation obligation) {
        Map<String, Object[]> obligationAttrMap = obligation.getAttributeMap();
        if (!obligationAttrMap.containsKey(this.id)) {
            return false;
        }
        if (!this.valueSet.isEmpty()) {
            Object[] attributeValues = obligationAttrMap.get(this.id);
            boolean valueFound = false;
            if (attributeValues != null) {
                for (Object attributeValue : attributeValues) {
                    if (!this.valueSet.contains(attributeValue)) continue;
                    valueFound = true;
                    break;
                }
            }
            return valueFound;
        }
        return true;
    }
}

