/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.CategoryContainer;
import org.apache.openaz.pepapi.Environment;
import org.apache.openaz.pepapi.MapperRegistry;
import org.apache.openaz.pepapi.ObjectMapper;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepException;
import org.apache.openaz.pepapi.std.ActionMapper;
import org.apache.openaz.pepapi.std.ActionResourcePairMapper;
import org.apache.openaz.pepapi.std.ArrayMapper;
import org.apache.openaz.pepapi.std.CategoryContainerMapper;
import org.apache.openaz.pepapi.std.CollectionMapper;
import org.apache.openaz.pepapi.std.ResourceMapper;
import org.apache.openaz.pepapi.std.SubjectMapper;

public final class StdMapperRegistry
implements MapperRegistry {
    private static final Log logger = LogFactory.getLog(StdMapperRegistry.class);
    private final Map<Class<?>, ObjectMapper> map;
    private PepConfig pepConfig;

    private StdMapperRegistry(PepConfig pepConfig) {
        this.pepConfig = pepConfig;
        this.map = new HashMap();
        this.registerMapper(new CollectionMapper());
        this.registerMapper(new ArrayMapper());
        this.registerMapper(new SubjectMapper());
        this.registerMapper(new ActionMapper());
        this.registerMapper(new ResourceMapper());
        this.registerMapper(new CategoryContainerMapper(Environment.class));
        this.registerMapper(new CategoryContainerMapper(CategoryContainer.class));
        this.registerMapper(new ActionResourcePairMapper());
    }

    public static MapperRegistry newInstance(PepConfig pepConfig) {
        return new StdMapperRegistry(pepConfig);
    }

    public static MapperRegistry newInstance(PepConfig pepConfig, List<ObjectMapper> mappers) {
        MapperRegistry mapperRegistry = StdMapperRegistry.newInstance(pepConfig);
        if (mappers != null) {
            mapperRegistry.registerMappers(mappers);
        }
        return mapperRegistry;
    }

    @Override
    public void registerMapper(ObjectMapper mapper) {
        mapper.setPepConfig(this.pepConfig);
        mapper.setMapperRegistry(this);
        this.map.put(mapper.getMappedClass(), mapper);
    }

    @Override
    public void registerMappers(Iterable<? extends ObjectMapper> mappers) {
        for (ObjectMapper objectMapper : mappers) {
            this.registerMapper(objectMapper);
        }
    }

    @Override
    public ObjectMapper getMapper(Class<?> clazz) {
        ObjectMapper mapper = null;
        Class<?> c = clazz;
        while (mapper == null && !c.equals(Object.class)) {
            mapper = this.getClassMapper(c);
            c = c.getSuperclass();
        }
        if (mapper == null && clazz.isArray()) {
            mapper = this.getMapper(Object[].class);
        }
        if (mapper != null) {
            logger.debug((Object)("Mapper :" + mapper.getClass().getName() + " found for class: " + clazz));
            return mapper;
        }
        throw new PepException("No ObjectMapper found for Object of Class: " + clazz);
    }

    private ObjectMapper getClassMapper(Class<?> clazz) {
        Class<?>[] interfaces;
        ObjectMapper mapper = this.map.get(clazz);
        if (mapper == null && (interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
            Class<?> inf;
            Class<?>[] arr$ = interfaces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (mapper = this.map.get(inf = arr$[i$])) == null; ++i$) {
            }
        }
        return mapper;
    }
}

