/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.api.pdp;

import java.util.Properties;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.ScopeResolver;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.FactoryFinder;
import org.apache.openaz.xacml.util.XACMLProperties;

public abstract class PDPEngineFactory {
    private static final String FACTORYID = "xacml.pdpEngineFactory";
    private static final String DEFAULT_FACTORY_CLASSNAME = "org.apache.openaz.xacml.pdp.OpenAZPDPEngineFactory";
    private Decision defaultBehavior = Decision.INDETERMINATE;
    private ScopeResolver scopeResolver;

    protected static Decision getConfiguredDefaultBehavior() {
        String defaultDecisionString = XACMLProperties.getProperty("xacml.pdp.behavior");
        if (defaultDecisionString != null && defaultDecisionString.length() > 0) {
            return Decision.get(defaultDecisionString);
        }
        return null;
    }

    protected static Decision getConfiguredDefaultBehavior(Properties properties) {
        String defaultDecisionString = properties.getProperty("xacml.pdp.behavior");
        if (defaultDecisionString != null && defaultDecisionString.length() > 0) {
            return Decision.get(defaultDecisionString);
        }
        return null;
    }

    protected PDPEngineFactory() {
    }

    public static PDPEngineFactory newInstance() throws FactoryException {
        PDPEngineFactory pdpEngineFactory = FactoryFinder.find(FACTORYID, DEFAULT_FACTORY_CLASSNAME, PDPEngineFactory.class);
        Decision defaultDecisionBehavior = PDPEngineFactory.getConfiguredDefaultBehavior();
        if (defaultDecisionBehavior != null) {
            pdpEngineFactory.setDefaultBehavior(defaultDecisionBehavior);
        }
        return pdpEngineFactory;
    }

    public static PDPEngineFactory newInstance(Properties properties) throws FactoryException {
        PDPEngineFactory pdpEngineFactory = FactoryFinder.find(FACTORYID, DEFAULT_FACTORY_CLASSNAME, PDPEngineFactory.class, properties);
        Decision defaultDecisionBehavior = PDPEngineFactory.getConfiguredDefaultBehavior(properties);
        if (defaultDecisionBehavior != null) {
            pdpEngineFactory.setDefaultBehavior(defaultDecisionBehavior);
        }
        return pdpEngineFactory;
    }

    public static PDPEngineFactory newInstance(String factoryClassName, ClassLoader classLoader) throws FactoryException {
        PDPEngineFactory pdpEngineFactory = FactoryFinder.newInstance(factoryClassName, PDPEngineFactory.class, classLoader, false);
        Decision defaultDecisionBehavior = PDPEngineFactory.getConfiguredDefaultBehavior();
        if (defaultDecisionBehavior != null) {
            pdpEngineFactory.setDefaultBehavior(defaultDecisionBehavior);
        }
        return pdpEngineFactory;
    }

    public static PDPEngineFactory newInstance(String factoryClassName) throws FactoryException {
        PDPEngineFactory pdpEngineFactory = FactoryFinder.newInstance(factoryClassName, PDPEngineFactory.class, null, true);
        Decision defaultDecisionBehavior = PDPEngineFactory.getConfiguredDefaultBehavior();
        if (defaultDecisionBehavior != null) {
            pdpEngineFactory.setDefaultBehavior(defaultDecisionBehavior);
        }
        return pdpEngineFactory;
    }

    public abstract PDPEngine newEngine() throws FactoryException;

    public abstract PDPEngine newEngine(Properties var1) throws FactoryException;

    public Decision getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(Decision decision) {
        this.defaultBehavior = decision;
    }

    public ScopeResolver getScopeResolver() {
        return this.scopeResolver;
    }

    public void setScopeResolver(ScopeResolver scopeResolverIn) {
        this.scopeResolver = scopeResolverIn;
    }
}

