/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.net.URI;
import java.util.UUID;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.util.ObjUtil;

public class IdentifierImpl
implements Identifier {
    private URI uri;

    public IdentifierImpl(URI uriIn) {
        if (uriIn == null) {
            throw new IllegalArgumentException("Null URI");
        }
        this.uri = uriIn;
    }

    public IdentifierImpl(String idIn) {
        this(URI.create(idIn));
    }

    public IdentifierImpl(Identifier identifierBase, String id) {
        this(URI.create(identifierBase.stringValue() + ":" + id));
    }

    public static Identifier gensym(String pfx) {
        UUID uuid = UUID.randomUUID();
        return new IdentifierImpl(pfx + ":" + uuid.toString());
    }

    public static Identifier gensym() {
        return IdentifierImpl.gensym("urn:gensym");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Identifier)) {
            return false;
        }
        return ObjUtil.equalsAllowNull(this.getUri(), ((Identifier)obj).getUri());
    }

    @Override
    public int hashCode() {
        URI thisURI = this.getUri();
        return thisURI == null ? super.hashCode() : thisURI.hashCode();
    }

    @Override
    public String stringValue() {
        URI thisURI = this.getUri();
        return thisURI == null ? null : thisURI.toString();
    }
}

