/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class StdDataTypeFactory
extends DataTypeFactory {
    private static final Map<Identifier, DataType<?>> mapIdentifiersToDataTypes = new HashMap();
    private static boolean mapNeedsInit = true;

    private static void registerDataType(DataType<?> dataType) {
        if (dataType != null && dataType.getId() != null) {
            mapIdentifiersToDataTypes.put(dataType.getId(), dataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMap() {
        if (mapNeedsInit) {
            Map<Identifier, DataType<?>> map = mapIdentifiersToDataTypes;
            synchronized (map) {
                if (mapNeedsInit) {
                    StdDataTypeFactory.registerDataType(DataTypes.DT_ANYURI);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_BASE64BINARY);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_BOOLEAN);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_DATE);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_DATETIME);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_DAYTIMEDURATION);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_DNSNAME);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_DOUBLE);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_HEXBINARY);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_INTEGER);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_IPADDRESS);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_RFC822NAME);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_STRING);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_TIME);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_X500NAME);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_XPATHEXPRESSION);
                    StdDataTypeFactory.registerDataType(DataTypes.DT_YEARMONTHDURATION);
                    mapNeedsInit = false;
                }
            }
        }
    }

    public StdDataTypeFactory() {
        StdDataTypeFactory.initMap();
    }

    @Override
    public DataType<?> getDataType(Identifier dataTypeId) {
        return mapIdentifiersToDataTypes.get(dataTypeId);
    }
}

