/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdIdReference
implements IdReference {
    private Identifier id;
    private Version version;

    public StdIdReference(Identifier idIn, Version versionIn) {
        this.id = idIn;
        this.version = versionIn;
    }

    public StdIdReference(Identifier idIn) {
        this(idIn, null);
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof IdReference)) {
            return false;
        }
        IdReference objIdReference = (IdReference)obj;
        return ObjUtil.equalsAllowNull(this.getId(), objIdReference.getId()) && ObjUtil.equalsAllowNull(this.getVersion(), objIdReference.getVersion());
    }

    public int hashCode() {
        int result = 17;
        if (this.getId() != null) {
            result = 31 * result + this.getId().hashCode();
        }
        if (this.getVersion() != null) {
            result = 31 * result + this.getVersion().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        SemanticString objectToDump = this.getId();
        if (objectToDump != null) {
            stringBuilder.append("id=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getVersion()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("version=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

