/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableAttribute
implements Attribute {
    private static final List<AttributeValue<?>> EMPTY_ATTRIBUTE_VALUE_LIST = Collections.unmodifiableList(new ArrayList());
    private Identifier attributeId;
    private Identifier category;
    private List<AttributeValue<?>> values = EMPTY_ATTRIBUTE_VALUE_LIST;
    private String issuer;
    private boolean includeInResults;

    public StdMutableAttribute() {
    }

    public StdMutableAttribute(Identifier categoryIdIn, Identifier attributeIdIn, Collection<AttributeValue<?>> valuesIn, String issuerIn, boolean includeInResultsIn) {
        this();
        this.attributeId = attributeIdIn;
        this.category = categoryIdIn;
        this.setValues(valuesIn);
        this.issuer = issuerIn;
        this.includeInResults = includeInResultsIn;
    }

    public StdMutableAttribute(Attribute attributeCopy) {
        this(attributeCopy.getCategory(), attributeCopy.getAttributeId(), attributeCopy.getValues(), attributeCopy.getIssuer(), attributeCopy.getIncludeInResults());
    }

    public StdMutableAttribute(Identifier categoryIdIn, Identifier attributeIdIn, AttributeValue<?> valueIn, String issuerIn, boolean includeInResultsIn) {
        this();
        this.attributeId = attributeIdIn;
        this.category = categoryIdIn;
        if (valueIn != null) {
            this.addValue(valueIn);
        }
        this.issuer = issuerIn;
        this.includeInResults = includeInResultsIn;
    }

    public StdMutableAttribute(Identifier categoryIdIn, Identifier attributeIdIn, AttributeValue<?> valueIn) {
        this(categoryIdIn, attributeIdIn, valueIn, null, false);
    }

    public static StdMutableAttribute copy(Attribute attribute) {
        return new StdMutableAttribute(attribute.getCategory(), attribute.getAttributeId(), attribute.getValues(), attribute.getIssuer(), attribute.getIncludeInResults());
    }

    @Override
    public Identifier getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(Identifier identifier) {
        this.attributeId = identifier;
    }

    @Override
    public Identifier getCategory() {
        return this.category;
    }

    public void setCategory(Identifier identifier) {
        this.category = identifier;
    }

    @Override
    public Collection<AttributeValue<?>> getValues() {
        return this.values == EMPTY_ATTRIBUTE_VALUE_LIST ? this.values : Collections.unmodifiableCollection(this.values);
    }

    public void addValue(AttributeValue<?> attributeValue) {
        if (this.values == EMPTY_ATTRIBUTE_VALUE_LIST) {
            this.values = new ArrayList();
        }
        this.values.add(attributeValue);
    }

    public void addValues(Collection<AttributeValue<?>> listAttributeValues) {
        if (listAttributeValues != null && listAttributeValues.size() > 0) {
            if (this.values == EMPTY_ATTRIBUTE_VALUE_LIST) {
                this.values = new ArrayList();
            }
            this.values.addAll(listAttributeValues);
        }
    }

    public void setValues(Collection<AttributeValue<?>> listAttributeValues) {
        this.values = EMPTY_ATTRIBUTE_VALUE_LIST;
        this.addValues(listAttributeValues);
    }

    @Override
    public <T> Iterator<AttributeValue<T>> findValues(final DataType<T> dataType) {
        final Iterator<AttributeValue<?>> iterAttributeValues = this.values.iterator();
        return new Iterator<AttributeValue<T>>(){
            private AttributeValue<T> attributeValueNextMatch = this.findNextMatch();

            private AttributeValue<T> findNextMatch() {
                AttributeValue attributeValue = null;
                while (attributeValue == null && iterAttributeValues.hasNext()) {
                    AttributeValue attributeValueTest = (AttributeValue)iterAttributeValues.next();
                    if (!attributeValueTest.getDataTypeId().equals(dataType.getId())) continue;
                    try {
                        attributeValue = dataType.convertAttributeValue(attributeValueTest);
                    }
                    catch (DataTypeException dataTypeException) {}
                }
                return attributeValue;
            }

            @Override
            public boolean hasNext() {
                return this.attributeValueNextMatch != null;
            }

            @Override
            public AttributeValue<T> next() {
                AttributeValue attributeValueNext = this.attributeValueNextMatch;
                this.attributeValueNextMatch = this.findNextMatch();
                return attributeValueNext;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }
        };
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuerIn) {
        this.issuer = issuerIn;
    }

    @Override
    public boolean getIncludeInResults() {
        return this.includeInResults;
    }

    public void setIncludeInResults(boolean b) {
        this.includeInResults = b;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Attribute)) {
            return false;
        }
        Attribute objAttribute = (Attribute)obj;
        return ObjUtil.equalsAllowNull(this.getCategory(), objAttribute.getCategory()) && ObjUtil.equalsAllowNull(this.getAttributeId(), objAttribute.getAttributeId()) && ObjUtil.equalsAllowNull(this.getIssuer(), objAttribute.getIssuer()) && this.getIncludeInResults() == objAttribute.getIncludeInResults() && ListUtil.equalsAllowNulls(this.getValues(), objAttribute.getValues());
    }

    public int hashCode() {
        int result = 17;
        if (this.getCategory() != null) {
            result = 31 * result + this.getCategory().hashCode();
        }
        if (this.getAttributeId() != null) {
            result = 31 * result + this.getAttributeId().hashCode();
        }
        result = 31 * result + Boolean.valueOf(this.getIncludeInResults()).hashCode();
        if (this.getIssuer() != null) {
            result = 31 * result + this.getIssuer().hashCode();
        }
        if (this.getValues() != null) {
            result = 31 * result + this.getValues().hashCode();
        }
        return result;
    }

    public String toString() {
        Collection<AttributeValue<?>> listValues;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getAttributeId();
        if (objectToDump != null) {
            stringBuilder.append("attributeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getCategory()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("category=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((listValues = this.getValues()).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("values=");
            stringBuilder.append(ListUtil.toString(listValues));
            needsComma = true;
        }
        if ((objectToDump = this.getIssuer()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("issuer=");
            stringBuilder.append((String)objectToDump);
            needsComma = true;
        }
        if (needsComma) {
            stringBuilder.append(',');
            stringBuilder.append("includeInResults=");
            stringBuilder.append(this.getIncludeInResults());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

