/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.Collection;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.std.StdMutableAttributeCategory;
import org.apache.openaz.xacml.util.ObjUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StdMutableRequestAttributes
extends StdMutableAttributeCategory
implements RequestAttributes {
    private Node contentRoot;
    private String xmlId;

    public StdMutableRequestAttributes() {
    }

    public StdMutableRequestAttributes(Identifier identifierCategory, Collection<Attribute> listAttributes, Node nodeContentRoot, String xmlIdIn) {
        super(identifierCategory, listAttributes);
        this.contentRoot = nodeContentRoot;
        this.xmlId = xmlIdIn;
    }

    public StdMutableRequestAttributes(RequestAttributes requestAttributes) {
        super(requestAttributes);
        this.contentRoot = requestAttributes.getContentRoot();
        this.xmlId = requestAttributes.getXmlId();
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlIdIn) {
        this.xmlId = xmlIdIn;
    }

    @Override
    public Node getContentRoot() {
        return this.contentRoot;
    }

    public void setContentRoot(Node nodeContentRoot) {
        this.contentRoot = nodeContentRoot;
    }

    @Override
    public Node getContentNodeByXpathExpression(XPathExpression xpathExpression) {
        if (xpathExpression == null) {
            throw new NullPointerException("Null XPathExpression");
        }
        Node nodeRootThis = this.getContentRoot();
        if (nodeRootThis == null) {
            return null;
        }
        Node matchingNode = null;
        try {
            matchingNode = (Node)xpathExpression.evaluate(nodeRootThis, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            this.logger.warn((Object)("Failed to retrieve node for \"" + xpathExpression.toString() + "\""), (Throwable)ex);
        }
        return matchingNode;
    }

    @Override
    public NodeList getContentNodeListByXpathExpression(XPathExpression xpathExpression) {
        if (xpathExpression == null) {
            throw new NullPointerException("Null XPathExpression");
        }
        Node nodeRootThis = this.getContentRoot();
        if (nodeRootThis == null) {
            return null;
        }
        NodeList matchingNodeList = null;
        try {
            matchingNodeList = (NodeList)xpathExpression.evaluate(nodeRootThis, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            this.logger.warn((Object)("Failed to retrieve nodelist for \"" + xpathExpression.toString() + "\""), (Throwable)ex);
        }
        return matchingNodeList;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RequestAttributes)) {
            return false;
        }
        RequestAttributes objRequestAttributes = (RequestAttributes)obj;
        return super.equals(objRequestAttributes) && ObjUtil.equalsAllowNull(this.getContentRoot(), objRequestAttributes.getContentRoot()) && ObjUtil.equalsAllowNull(this.getXmlId(), objRequestAttributes.getXmlId());
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.getContentRoot() != null) {
            result = 31 * result + this.getContentRoot().hashCode();
        }
        if (this.getXmlId() != null) {
            result = 31 * result + this.getXmlId().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getContentRoot();
        if (objectToDump != null) {
            stringBuilder.append(',');
            stringBuilder.append("contentRoot=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getXmlId()) != null) {
            stringBuilder.append(',');
            stringBuilder.append("xmlId=");
            stringBuilder.append((String)objectToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

