/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.std.StdMutableResult;
import org.apache.openaz.xacml.util.ListUtil;

public class StdMutableResponse
implements Response {
    private static final List<Result> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private List<Result> results;

    public StdMutableResponse() {
        this.results = EMPTY_LIST;
    }

    public StdMutableResponse(Result resultIn) {
        if (resultIn != null) {
            this.results = new ArrayList<Result>();
            this.results.add(resultIn);
        } else {
            this.results = EMPTY_LIST;
        }
    }

    public StdMutableResponse(Collection<Result> listResults) {
        if (listResults != null && listResults.size() > 0) {
            this.results = new ArrayList<Result>();
            this.results.addAll(listResults);
        } else {
            this.results = EMPTY_LIST;
        }
    }

    public StdMutableResponse(Response copy) {
        this(copy.getResults());
    }

    public StdMutableResponse(Status status) {
        this(new StdMutableResult(status));
    }

    @Override
    public Collection<Result> getResults() {
        return this.results == EMPTY_LIST ? this.results : Collections.unmodifiableCollection(this.results);
    }

    public void add(Result result) {
        if (this.results == EMPTY_LIST) {
            this.results = new ArrayList<Result>();
        }
        this.results.add(result);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Response)) {
            return false;
        }
        Response objResponse = (Response)obj;
        return ListUtil.equalsAllowNulls(this.getResults(), objResponse.getResults());
    }

    public int hashCode() {
        int result = 17;
        if (this.getResults() != null) {
            result = 31 * result + this.getResults().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Collection<Result> listResults = this.getResults();
        if (listResults.size() > 0) {
            stringBuilder.append("results=");
            stringBuilder.append(ListUtil.toString(listResults));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

