/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableResult
implements Result {
    private static final List<Obligation> EMPTY_OBLIGATION_LIST = Collections.unmodifiableList(new ArrayList());
    private static final List<Advice> EMPTY_ADVICE_LIST = Collections.unmodifiableList(new ArrayList());
    private static final List<AttributeCategory> EMPTY_ATTRIBUTES = Collections.unmodifiableList(new ArrayList());
    private static final List<IdReference> EMPTY_REFERENCES = Collections.unmodifiableList(new ArrayList());
    private Decision decision;
    private Status status;
    private List<Obligation> obligations = new ArrayList<Obligation>();
    private List<Advice> associatedAdvice = new ArrayList<Advice>();
    private List<AttributeCategory> attributes = new ArrayList<AttributeCategory>();
    private List<IdReference> policyIdentifiers = new ArrayList<IdReference>();
    private List<IdReference> policySetIdentifiers = new ArrayList<IdReference>();

    public StdMutableResult() {
        this.obligations = EMPTY_OBLIGATION_LIST;
        this.associatedAdvice = EMPTY_ADVICE_LIST;
        this.attributes = EMPTY_ATTRIBUTES;
        this.policyIdentifiers = EMPTY_REFERENCES;
        this.policySetIdentifiers = EMPTY_REFERENCES;
    }

    public StdMutableResult(Result resultCopy) {
        this(resultCopy.getDecision(), resultCopy.getStatus());
        this.addObligations(resultCopy.getObligations());
        this.addAdvice(resultCopy.getAssociatedAdvice());
        this.addAttributeCategories(resultCopy.getAttributes());
        this.addPolicyIdentifiers(resultCopy.getPolicyIdentifiers());
        this.addPolicySetIdentifiers(resultCopy.getPolicySetIdentifiers());
    }

    public StdMutableResult(Decision decisionIn, Status statusIn) {
        this();
        this.status = statusIn;
        this.decision = decisionIn;
    }

    public StdMutableResult(Status statusIn) {
        this(Decision.INDETERMINATE, statusIn);
    }

    public StdMutableResult(Decision decisionIn) {
        this(decisionIn, StdStatus.STATUS_OK);
    }

    public StdMutableResult(Decision decisionIn, Collection<Obligation> obligationsIn, Collection<Advice> adviceIn, Collection<AttributeCategory> attributesIn, Collection<IdReference> policyIdentifiersIn, Collection<IdReference> policySetIdentifiersIn) {
        this(decisionIn);
        this.setObligations(obligationsIn);
        this.setAdvice(adviceIn);
        this.setAttributeCategories(attributesIn);
        this.setPolicyIdentifiers(policyIdentifiersIn);
        this.setPolicySetIdentifiers(policySetIdentifiersIn);
    }

    @Override
    public Decision getDecision() {
        return this.decision;
    }

    public void setDecision(Decision decisionIn) {
        this.decision = decisionIn;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status statusIn) {
        this.status = statusIn;
    }

    @Override
    public Collection<Obligation> getObligations() {
        return this.obligations == EMPTY_OBLIGATION_LIST ? this.obligations : Collections.unmodifiableCollection(this.obligations);
    }

    public void addObligation(Obligation obligation) {
        if (this.obligations == EMPTY_OBLIGATION_LIST) {
            this.obligations = new ArrayList<Obligation>();
        }
        this.obligations.add(obligation);
    }

    public void addObligations(Collection<Obligation> obligationsIn) {
        if (obligationsIn != null && obligationsIn.size() > 0) {
            if (this.obligations == EMPTY_OBLIGATION_LIST) {
                this.obligations = new ArrayList<Obligation>();
            }
            this.obligations.addAll(obligationsIn);
        }
    }

    public void setObligations(Collection<Obligation> obligationsIn) {
        this.obligations = EMPTY_OBLIGATION_LIST;
        this.addObligations(obligationsIn);
    }

    @Override
    public Collection<Advice> getAssociatedAdvice() {
        return this.associatedAdvice == EMPTY_ADVICE_LIST ? this.associatedAdvice : Collections.unmodifiableCollection(this.associatedAdvice);
    }

    public void addAdvice(Advice advice) {
        if (this.associatedAdvice == EMPTY_ADVICE_LIST) {
            this.associatedAdvice = new ArrayList<Advice>();
        }
        this.associatedAdvice.add(advice);
    }

    public void addAdvice(Collection<Advice> adviceIn) {
        if (adviceIn != null && adviceIn.size() > 0) {
            if (this.associatedAdvice == EMPTY_ADVICE_LIST) {
                this.associatedAdvice = new ArrayList<Advice>();
            }
            this.associatedAdvice.addAll(adviceIn);
        }
    }

    public void setAdvice(Collection<Advice> adviceIn) {
        this.associatedAdvice = EMPTY_ADVICE_LIST;
        this.addAdvice(adviceIn);
    }

    @Override
    public Collection<AttributeCategory> getAttributes() {
        return this.attributes == EMPTY_ATTRIBUTES ? this.attributes : Collections.unmodifiableCollection(this.attributes);
    }

    public void addAttributeCategory(AttributeCategory attribute) {
        if (this.attributes == EMPTY_ATTRIBUTES) {
            this.attributes = new ArrayList<AttributeCategory>();
        }
        this.attributes.add(attribute);
    }

    public void addAttributeCategories(Collection<AttributeCategory> listAttributeCategories) {
        if (listAttributeCategories != null && listAttributeCategories.size() > 0) {
            if (this.attributes == EMPTY_ATTRIBUTES) {
                this.attributes = new ArrayList<AttributeCategory>();
            }
            this.attributes.addAll(listAttributeCategories);
        }
    }

    public void setAttributeCategories(Collection<AttributeCategory> listAttributeCategories) {
        this.attributes = EMPTY_ATTRIBUTES;
        this.addAttributeCategories(listAttributeCategories);
    }

    @Override
    public Collection<IdReference> getPolicyIdentifiers() {
        return this.policyIdentifiers == EMPTY_REFERENCES ? this.policyIdentifiers : Collections.unmodifiableCollection(this.policyIdentifiers);
    }

    public void addPolicyIdentifier(IdReference policyIdentifier) {
        if (this.policyIdentifiers == EMPTY_REFERENCES) {
            this.policyIdentifiers = new ArrayList<IdReference>();
        }
        this.policyIdentifiers.add(policyIdentifier);
    }

    public void addPolicyIdentifiers(Collection<IdReference> policyIdentifierList) {
        if (policyIdentifierList != null && policyIdentifierList.size() > 0) {
            if (this.policyIdentifiers == EMPTY_REFERENCES) {
                this.policyIdentifiers = new ArrayList<IdReference>();
            }
            this.policyIdentifiers.addAll(policyIdentifierList);
        }
    }

    public void setPolicyIdentifiers(Collection<IdReference> policyIdentifierList) {
        this.policyIdentifiers = EMPTY_REFERENCES;
        this.addPolicyIdentifiers(policyIdentifierList);
    }

    @Override
    public Collection<IdReference> getPolicySetIdentifiers() {
        return this.policySetIdentifiers == EMPTY_REFERENCES ? this.policySetIdentifiers : Collections.unmodifiableCollection(this.policySetIdentifiers);
    }

    public void addPolicySetIdentifier(IdReference policyIdentifier) {
        if (this.policySetIdentifiers == EMPTY_REFERENCES) {
            this.policySetIdentifiers = new ArrayList<IdReference>();
        }
        this.policySetIdentifiers.add(policyIdentifier);
    }

    public void addPolicySetIdentifiers(Collection<IdReference> policyIdentifierList) {
        if (policyIdentifierList != null && policyIdentifierList.size() > 0) {
            if (this.policySetIdentifiers == EMPTY_REFERENCES) {
                this.policySetIdentifiers = new ArrayList<IdReference>();
            }
            this.policySetIdentifiers.addAll(policyIdentifierList);
        }
    }

    public void setPolicySetIdentifiers(Collection<IdReference> policyIdentifierList) {
        this.policySetIdentifiers = EMPTY_REFERENCES;
        this.addPolicySetIdentifiers(policyIdentifierList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Result)) {
            return false;
        }
        Result objResult = (Result)obj;
        return ObjUtil.equalsAllowNull(this.getDecision(), objResult.getDecision()) && ObjUtil.equalsAllowNull(this.getStatus(), objResult.getStatus()) && ListUtil.equalsAllowNulls(this.getObligations(), objResult.getObligations()) && ListUtil.equalsAllowNulls(this.getAssociatedAdvice(), objResult.getAssociatedAdvice()) && ListUtil.equalsAllowNulls(this.getAttributes(), objResult.getAttributes()) && ListUtil.equalsAllowNulls(this.getPolicyIdentifiers(), objResult.getPolicyIdentifiers()) && ListUtil.equalsAllowNulls(this.getPolicySetIdentifiers(), objResult.getPolicySetIdentifiers());
    }

    public int hashCode() {
        int result = 17;
        if (this.getDecision() != null) {
            result = 31 * result + this.getDecision().hashCode();
        }
        if (this.getStatus() != null) {
            result = 31 * result + this.getStatus().hashCode();
        }
        if (this.getObligations() != null) {
            result = 31 * result + this.getObligations().hashCode();
        }
        if (this.getAssociatedAdvice() != null) {
            result = 31 * result + this.getAssociatedAdvice().hashCode();
        }
        if (this.getAttributes() != null) {
            result = 31 * result + this.getAttributes().hashCode();
        }
        if (this.getPolicyIdentifiers() != null) {
            result = 31 * result + this.getPolicyIdentifiers().hashCode();
        }
        if (this.getPolicySetIdentifiers() != null) {
            result = 31 * result + this.getPolicySetIdentifiers().hashCode();
        }
        return result;
    }

    public String toString() {
        List<Object> listToDump;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object toDump = this.getDecision();
        if (toDump != null) {
            stringBuilder.append("decision=" + ((Object)toDump).toString());
            needsComma = true;
        }
        if ((toDump = this.getStatus()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("status=");
            stringBuilder.append(((Object)toDump).toString());
            needsComma = true;
        }
        if ((listToDump = this.obligations).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("obligations=");
            stringBuilder.append(ListUtil.toString(listToDump));
            needsComma = true;
        }
        if ((listToDump = this.associatedAdvice).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("associatedAdvice=");
            stringBuilder.append(ListUtil.toString(listToDump));
            needsComma = true;
        }
        if ((listToDump = this.attributes).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributeCategories=");
            stringBuilder.append(ListUtil.toString(listToDump));
            needsComma = true;
        }
        if ((listToDump = this.policyIdentifiers).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("policyIdentifiers=");
            stringBuilder.append(ListUtil.toString(listToDump));
            needsComma = true;
        }
        if ((listToDump = this.policySetIdentifiers).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("policySetIdentifiers=");
            stringBuilder.append(ListUtil.toString(listToDump));
            needsComma = true;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

