/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.StatusDetail;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableStatus
implements Status {
    private StatusCode statusCode;
    private String statusMessage;
    private StatusDetail statusDetail;

    public StdMutableStatus(StatusCode statusCodeIn, String statusMessageIn, StatusDetail statusDetailIn) {
        this.statusCode = statusCodeIn;
        this.statusMessage = statusMessageIn;
        this.statusDetail = statusDetailIn;
    }

    public StdMutableStatus(StatusCode statusCodeIn, String statusMessageIn) {
        this(statusCodeIn, statusMessageIn, null);
    }

    public StdMutableStatus(StatusCode statusCodeIn) {
        this(statusCodeIn, null, null);
    }

    public StdMutableStatus() {
    }

    public static StdMutableStatus copy(Status status) {
        return new StdMutableStatus(status.getStatusCode(), status.getStatusMessage(), status.getStatusDetail());
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCodeIn) {
        this.statusCode = statusCodeIn;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    @Override
    public StatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(StatusDetail statusDetailIn) {
        this.statusDetail = statusDetailIn;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Status)) {
            return false;
        }
        Status objStatus = (Status)obj;
        return ObjUtil.equalsAllowNull(this.getStatusCode(), objStatus.getStatusCode()) && ObjUtil.equalsAllowNull(this.getStatusMessage(), objStatus.getStatusMessage()) && ObjUtil.equalsAllowNull(this.getStatusDetail(), objStatus.getStatusDetail());
    }

    public int hashCode() {
        int result = 17;
        if (this.getStatusCode() != null) {
            result = 31 * result + this.getStatusCode().hashCode();
        }
        if (this.getStatusMessage() != null) {
            result = 31 * result + this.getStatusMessage().hashCode();
        }
        if (this.getStatusDetail() != null) {
            result = 31 * result + this.getStatusDetail().hashCode();
        }
        return result;
    }

    @Override
    public boolean isOk() {
        StatusCode thisStatusCode = this.getStatusCode();
        return thisStatusCode == null || thisStatusCode.equals(StdStatusCode.STATUS_CODE_OK);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getStatusCode();
        if (objectToDump != null) {
            stringBuilder.append("statusCode=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getStatusMessage()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("statusMessage=");
            stringBuilder.append((String)objectToDump);
            needsComma = true;
        }
        if ((objectToDump = this.getStatusDetail()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("statusDetail=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Status merge(Status status) {
        if (status == null || !this.getStatusCode().equals(status.getStatusCode()) || status.getStatusDetail() == null) {
            return this;
        }
        if (this.getStatusDetail() == null) {
            return new StdMutableStatus(this.getStatusCode(), this.getStatusMessage(), status.getStatusDetail());
        }
        return new StdMutableStatus(this.getStatusCode(), this.getStatusMessage(), this.getStatusDetail().merge(status.getStatusDetail()));
    }
}

