/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.Collection;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.std.StdAttributeCategory;
import org.apache.openaz.xacml.util.ObjUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StdRequestAttributes
extends StdAttributeCategory
implements RequestAttributes {
    private Log logger = LogFactory.getLog(this.getClass());
    private Node contentRoot;
    private String xmlId;

    public StdRequestAttributes(Identifier identifierCategory, Collection<Attribute> listAttributes, Node nodeContentRoot, String xmlIdIn) {
        super(identifierCategory, listAttributes);
        this.contentRoot = nodeContentRoot;
        this.xmlId = xmlIdIn;
    }

    public StdRequestAttributes(RequestAttributes requestAttributes) {
        super(requestAttributes);
        this.contentRoot = requestAttributes.getContentRoot();
        this.xmlId = requestAttributes.getXmlId();
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public Node getContentRoot() {
        return this.contentRoot;
    }

    @Override
    public Node getContentNodeByXpathExpression(XPathExpression xpathExpression) {
        if (xpathExpression == null) {
            throw new NullPointerException("Null XPathExpression");
        }
        Node nodeRootThis = this.getContentRoot();
        if (nodeRootThis == null) {
            return null;
        }
        Node matchingNode = null;
        try {
            matchingNode = (Node)xpathExpression.evaluate(nodeRootThis, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            this.logger.warn((Object)("Failed to retrieve node for \"" + xpathExpression.toString() + "\""), (Throwable)ex);
        }
        return matchingNode;
    }

    @Override
    public NodeList getContentNodeListByXpathExpression(XPathExpression xpathExpression) {
        if (xpathExpression == null) {
            throw new NullPointerException("Null XPathExpression");
        }
        Node nodeRootThis = this.getContentRoot();
        if (nodeRootThis == null) {
            return null;
        }
        NodeList matchingNodeList = null;
        try {
            matchingNodeList = (NodeList)xpathExpression.evaluate(nodeRootThis, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            this.logger.warn((Object)("Failed to retrieve nodelist for \"" + xpathExpression.toString() + "\""), (Throwable)ex);
        }
        return matchingNodeList;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RequestAttributes)) {
            return false;
        }
        RequestAttributes objRequestAttributes = (RequestAttributes)obj;
        if (!ObjUtil.xmlEqualsAllowNull(this.getContentRoot(), objRequestAttributes.getContentRoot())) {
            return false;
        }
        return super.equals(objRequestAttributes) && ObjUtil.equalsAllowNull(this.getXmlId(), objRequestAttributes.getXmlId());
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.getContentRoot() != null) {
            result = 31 * result + this.getContentRoot().hashCode();
        }
        if (this.getXmlId() != null) {
            result = 31 * result + this.getXmlId().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getContentRoot();
        if (objectToDump != null) {
            stringBuilder.append(',');
            stringBuilder.append("contentRoot=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getXmlId()) != null) {
            stringBuilder.append(',');
            stringBuilder.append("xmlId=");
            stringBuilder.append((String)objectToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

