/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.annotations;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributesReference;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;
import org.apache.openaz.xacml.std.StdRequestAttributesReference;
import org.apache.openaz.xacml.std.StdRequestDefaults;
import org.apache.openaz.xacml.std.StdRequestReference;
import org.apache.openaz.xacml.std.annotations.XACMLAction;
import org.apache.openaz.xacml.std.annotations.XACMLAttribute;
import org.apache.openaz.xacml.std.annotations.XACMLEnvironment;
import org.apache.openaz.xacml.std.annotations.XACMLMultiRequest;
import org.apache.openaz.xacml.std.annotations.XACMLRequest;
import org.apache.openaz.xacml.std.annotations.XACMLRequestReference;
import org.apache.openaz.xacml.std.annotations.XACMLResource;
import org.apache.openaz.xacml.std.annotations.XACMLSubject;
import org.apache.openaz.xacml.std.datatypes.Base64Binary;
import org.apache.openaz.xacml.std.datatypes.HexBinary;
import org.apache.openaz.xacml.std.datatypes.IPAddress;
import org.apache.openaz.xacml.std.datatypes.ISO8601Date;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Time;
import org.apache.openaz.xacml.std.datatypes.RFC2396DomainName;
import org.apache.openaz.xacml.std.datatypes.RFC822Name;
import org.apache.openaz.xacml.std.datatypes.XPathDayTimeDuration;
import org.apache.openaz.xacml.std.datatypes.XPathYearMonthDuration;
import org.apache.openaz.xacml.util.AttributeUtils;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathExpression;

public class RequestParser {
    private static Log logger = LogFactory.getLog(RequestParser.class);
    protected static DataTypeFactory dataTypeFactory = null;

    protected static synchronized DataTypeFactory getDataTypeFactory() {
        try {
            if (dataTypeFactory != null) {
                return dataTypeFactory;
            }
            dataTypeFactory = DataTypeFactory.newInstance();
            if (dataTypeFactory == null) {
                logger.error((Object)"Could not create data type factory");
            }
        }
        catch (FactoryException e) {
            logger.error((Object)("Can't get Data type Factory: " + e.getLocalizedMessage()));
        }
        return dataTypeFactory;
    }

    public static Request parseRequest(Object obj) throws IllegalArgumentException, IllegalAccessException, DataTypeException {
        XACMLMultiRequest multi;
        StdMutableRequest stdMutableRequest = new StdMutableRequest();
        ArrayList<StdMutableRequestAttributes> attributes = new ArrayList<StdMutableRequestAttributes>();
        XACMLRequest requestAnnotation = obj.getClass().getAnnotation(XACMLRequest.class);
        stdMutableRequest.setReturnPolicyIdList(requestAnnotation.ReturnPolicyIdList());
        stdMutableRequest.setCombinedDecision(requestAnnotation.CombinedDecision());
        if (!requestAnnotation.Defaults().equals("NULL")) {
            stdMutableRequest.setRequestDefaults(new StdRequestDefaults(URI.create(requestAnnotation.Defaults())));
        }
        if ((multi = requestAnnotation.multiRequest()) != null) {
            for (XACMLRequestReference reference : multi.values()) {
                ArrayList<RequestAttributesReference> refs = new ArrayList<RequestAttributesReference>();
                for (String id : reference.values()) {
                    refs.add(new StdRequestAttributesReference(id));
                }
                if (refs.isEmpty()) continue;
                stdMutableRequest.add(new StdRequestReference((Collection<RequestAttributesReference>)refs));
            }
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            XACMLAttribute attribute;
            XACMLEnvironment environment;
            XACMLResource resource;
            XACMLAction action;
            XACMLSubject subject;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Field: " + field));
            }
            if ((subject = field.getAnnotation(XACMLSubject.class)) != null) {
                RequestParser.addAttribute(attributes, new IdentifierImpl(subject.category()), new IdentifierImpl(subject.attributeId()), subject.includeInResults(), subject.datatype().equals("NULL") ? null : subject.datatype(), subject.issuer().equals("NULL") ? null : subject.issuer(), subject.id().equals("NULL") ? null : subject.id(), field, obj);
            }
            if ((action = field.getAnnotation(XACMLAction.class)) != null) {
                RequestParser.addAttribute(attributes, new IdentifierImpl(action.category()), new IdentifierImpl(action.attributeId()), action.includeInResults(), action.datatype().equals("NULL") ? null : action.datatype(), action.issuer().equals("NULL") ? null : action.issuer(), action.id().equals("NULL") ? null : action.id(), field, obj);
            }
            if ((resource = field.getAnnotation(XACMLResource.class)) != null) {
                RequestParser.addAttribute(attributes, new IdentifierImpl(resource.category()), new IdentifierImpl(resource.attributeId()), resource.includeInResults(), resource.datatype().equals("NULL") ? null : resource.datatype(), resource.issuer().equals("NULL") ? null : resource.issuer(), resource.id().equals("NULL") ? null : resource.id(), field, obj);
            }
            if ((environment = field.getAnnotation(XACMLEnvironment.class)) != null) {
                RequestParser.addAttribute(attributes, new IdentifierImpl(environment.category()), new IdentifierImpl(environment.attributeId()), environment.includeInResults(), environment.datatype().equals("NULL") ? null : environment.datatype(), environment.issuer().equals("NULL") ? null : environment.issuer(), environment.id().equals("NULL") ? null : environment.id(), field, obj);
            }
            if ((attribute = field.getAnnotation(XACMLAttribute.class)) == null) continue;
            RequestParser.addAttribute(attributes, new IdentifierImpl(attribute.category()), new IdentifierImpl(attribute.attributeId()), attribute.includeInResults(), attribute.datatype().equals("NULL") ? null : attribute.datatype(), attribute.issuer().equals("NULL") ? null : attribute.issuer(), attribute.id().equals("NULL") ? null : attribute.id(), field, obj);
        }
        for (StdMutableRequestAttributes a : attributes) {
            stdMutableRequest.add(a);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)AttributeUtils.prettyPrint(stdMutableRequest));
        }
        return stdMutableRequest;
    }

    public static void addAttribute(List<StdMutableRequestAttributes> attributes, Identifier category, Identifier attributeId, boolean includeInResults, String datatype, String issuer, String id, Field field, Object object) throws IllegalArgumentException, IllegalAccessException, DataTypeException {
        StdMutableAttribute mutableAttribute = new StdMutableAttribute();
        mutableAttribute.setCategory(category);
        mutableAttribute.setAttributeId(attributeId);
        mutableAttribute.setIncludeInResults(includeInResults);
        if (issuer != null && !issuer.isEmpty()) {
            mutableAttribute.setIssuer(issuer);
        }
        field.setAccessible(true);
        Collection<AttributeValue<?>> value = RequestParser.extractValues(datatype, field, object);
        if (value == null) {
            throw new IllegalArgumentException("Unable to extract attribute value from object");
        }
        mutableAttribute.addValues(value);
        boolean added = false;
        for (StdMutableRequestAttributes a : attributes) {
            if (!(a.getCategory().equals(mutableAttribute.getCategory()) && id != null ? a.getXmlId().equals(id) : a.getXmlId() == null)) continue;
            a.add(mutableAttribute);
            added = true;
            break;
        }
        if (!added) {
            StdMutableRequestAttributes newAttributes = new StdMutableRequestAttributes();
            newAttributes.setCategory(mutableAttribute.getCategory());
            newAttributes.setXmlId(id);
            newAttributes.add(mutableAttribute);
            attributes.add(newAttributes);
        }
    }

    public static Collection<AttributeValue<?>> extractValues(String datatype, Field field, Object object) throws IllegalArgumentException, IllegalAccessException, DataTypeException {
        DataTypeFactory dtFactory = RequestParser.getDataTypeFactory();
        if (dtFactory == null) {
            logger.error((Object)"Could not create data type factory");
            return null;
        }
        ArrayList values = new ArrayList();
        Object fieldObject = field.get(object);
        if (logger.isDebugEnabled()) {
            logger.debug(fieldObject);
        }
        if (fieldObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"field's object is null.");
            }
            return values;
        }
        if (field.get(object) instanceof Collection || field.get(object) instanceof Map) {
            Collection objects = (Collection)field.get(object);
            if (objects == null || objects.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"empty collection");
                }
                return values;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Object is a collection");
            }
            for (Object obj : objects) {
                values.add(RequestParser.extractValue(datatype, obj));
            }
        } else if (fieldObject.getClass().isArray()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Object is an array");
            }
            for (int i = 0; i < Array.getLength(fieldObject); ++i) {
                values.add(RequestParser.extractValue(datatype, Array.get(fieldObject, i)));
            }
        } else {
            values.add(RequestParser.extractValue(datatype, field.get(object)));
        }
        return values;
    }

    protected static AttributeValue<?> extractValue(String datatype, Object object) throws DataTypeException {
        Identifier datatypeId;
        if (datatype == null) {
            if (object instanceof String) {
                datatypeId = XACML3.ID_DATATYPE_STRING;
            } else if (object instanceof Integer || object instanceof Long) {
                datatypeId = XACML3.ID_DATATYPE_INTEGER;
            } else if (object instanceof Boolean) {
                datatypeId = XACML3.ID_DATATYPE_BOOLEAN;
            } else if (object instanceof Double || object instanceof Float) {
                datatypeId = XACML3.ID_DATATYPE_DOUBLE;
            } else if (object instanceof Date || object instanceof Calendar || object instanceof ISO8601DateTime) {
                datatypeId = XACML3.ID_DATATYPE_DATETIME;
            } else if (object instanceof URI) {
                datatypeId = XACML3.ID_DATATYPE_ANYURI;
            } else if (object instanceof ISO8601Date) {
                datatypeId = XACML3.ID_DATATYPE_DATE;
            } else if (object instanceof ISO8601Time) {
                datatypeId = XACML3.ID_DATATYPE_TIME;
            } else if (object instanceof RFC2396DomainName) {
                datatypeId = XACML3.ID_DATATYPE_DNSNAME;
            } else if (object instanceof byte[] || object instanceof HexBinary) {
                datatypeId = XACML3.ID_DATATYPE_HEXBINARY;
            } else if (object instanceof Base64Binary) {
                datatypeId = XACML3.ID_DATATYPE_BASE64BINARY;
            } else if (object instanceof XPathDayTimeDuration) {
                datatypeId = XACML3.ID_DATATYPE_DAYTIMEDURATION;
            } else if (object instanceof IPAddress) {
                datatypeId = XACML3.ID_DATATYPE_IPADDRESS;
            } else if (object instanceof RFC822Name) {
                datatypeId = XACML3.ID_DATATYPE_RFC822NAME;
            } else if (object instanceof X500Principal) {
                datatypeId = XACML3.ID_DATATYPE_X500NAME;
            } else if (object instanceof XPathExpression || object instanceof Node) {
                datatypeId = XACML3.ID_DATATYPE_XPATHEXPRESSION;
            } else if (object instanceof XPathYearMonthDuration) {
                datatypeId = XACML3.ID_DATATYPE_YEARMONTHDURATION;
            } else {
                logger.warn((Object)"Cannot decipher java object, defaulting to String datatype. If this is not correct, you must specify the datatype in the annotation.");
                datatypeId = XACML3.ID_DATATYPE_STRING;
            }
        } else {
            datatypeId = new IdentifierImpl(datatype);
        }
        DataType<?> dataTypeExtended = RequestParser.getDataTypeFactory().getDataType(datatypeId);
        if (dataTypeExtended == null) {
            logger.error((Object)("DataType factory does not know datatype: " + datatype));
            return null;
        }
        return dataTypeExtended.createAttributeValue(object);
    }
}

